/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.file.action;

import com.ericsson.ere.io.IOUtil;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.util.FileHandling;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileAction
extends AbstractAction {
    public static String TAG_FILE = "File";

    public static void deleteFile(Node fileNode) throws Exception {
        String fileName = FileAction.getAttribute("Name", fileNode);
        String directory = FileAction.getAttribute("Dir", fileNode);
        File file = new File(directory + fileName);
        if (!file.exists()) {
            throw new Exception("'" + directory + fileName + "' does NOT exist");
        }
        file.delete();
    }

    public static String getFile(Node fileNode) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String fileName = FileAction.getAttribute("Name", fileNode);
        String directory = FileAction.getAttribute("Dir", fileNode);
        File file = new File(directory + fileName);
        if (!file.exists()) {
            throw new Exception("'" + directory + fileName + "' does NOT exist");
        }
        FileReader reader = new FileReader(directory + fileName);
        IOUtil.readAllAndClose(reader, buffer);
        return "<File Name= \"" + fileName + "\" Dir=\"" + directory + "\"/>\n" + buffer.toString();
    }

    public static void createFile(Node fileNode) throws Exception {
        File file;
        Node nodeToFile = null;
        String fileName = FileAction.getAttribute("Name", fileNode);
        String directory = FileAction.getAttribute("Dir", fileNode);
        NodeList childNodes = fileNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            nodeToFile = FileAction.getFirstElementNode(childNodes);
        }
        if ((file = new File(directory + fileName)).exists()) {
            throw new Exception("'" + directory + fileName + "' exists can not create this file.");
        }
        if (nodeToFile == null) {
            throw new Exception("Nothing to write to file");
        }
        FileHandling.writeToFile(nodeToFile.toString(), new File(directory + fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFile(Node fileNode) throws Exception {
        File file;
        Node nodeToFile = null;
        String fileName = FileAction.getAttribute("Name", fileNode);
        String directory = FileAction.getAttribute("Dir", fileNode);
        NodeList childNodes = fileNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            nodeToFile = FileAction.getFirstElementNode(childNodes);
        }
        if (!(file = new File(directory + fileName)).exists()) {
            throw new Exception("'" + directory + fileName + "' does NOT exist");
        }
        if (nodeToFile != null) {
            try (FileWriter writer = new FileWriter(directory + fileName);){
                writer.write(nodeToFile.toString());
                writer.flush();
            }
        } else {
            throw new Exception("Node null");
        }
    }

    public static Node getFirstElementNode(NodeList list) throws Exception {
        for (int ii = 0; ii < list.getLength(); ++ii) {
            if (list.item(ii).getNodeType() != 1) continue;
            return list.item(ii);
        }
        throw new Exception("No Element Node found in file content");
    }
}

