/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.rate.action;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.MillisecondAllocatableRatingDataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.dataset.task.ContinuousMillisecondTimeTask;
import com.ericsson.ere.dataset.task.ContinuousTimeTask;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.NoTreeFoundException;
import com.ericsson.ere.trace.TraceTreeExecutor;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.exception.RatingException;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.rate.action.RateTracer;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.xml.XMLUtil;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmmRateAction
extends AbstractAction
implements EreAction {
    private static final String MSG_NOT_ENOUGH_MONEY = "Rating failed duration set to zero, not enough money ...";
    private static final String TAG_RATE = "Rate";
    private static final String ATTR_SERVICEPROVIDER = "ServiceProvider";
    private static final String ATTR_RATINGPLAN = "RatingPlan";
    private static final String ATTR_DATE = "Date";
    private static final String ATTR_DURATION = "Duration";
    private static final String ATTR_COST = "Cost";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_VALUE = "Value";
    private static final String TAG_CALLDATARECORD = "calldatarecord";
    private static final String TAG_CDR = "cdr";
    private static final String TAG_RATEVALUE = "RateValue";
    private static final String ATTR_TYPE = "Type";

    @Override
    public String perform(NodeList config) throws Exception {
        StringBuffer buffer = new StringBuffer("");
        for (int ii = 0; ii < config.getLength(); ++ii) {
            if (config.item(ii).getNodeType() != 1 || !config.item(ii).getNodeName().equals(TAG_RATE)) continue;
            try {
                buffer.append(this.performRatingRequest(config.item(ii)).toString());
                continue;
            }
            catch (Exception e) {
                buffer.append("<Error>\n" + e.getMessage() + "\n</Error>\n");
            }
        }
        return buffer.toString();
    }

    private StringBuffer performRatingRequest(Node rateRequest) throws Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            if (!rateRequest.hasAttributes()) {
                throw new Exception("NO attributes for tag <Rate/> missing ");
            }
            buffer.append(this.performRate(rateRequest));
        }
        catch (Exception e) {
            throw new Exception("Error performing rate request due to " + e.getMessage(), e);
        }
        return buffer;
    }

    private void addSuccessMessage(StringBuffer buf, double cost, long duration) {
        buf.append(this.createRateValueTag("ERE_ResultCode", "Integer", "0"));
        buf.append(this.createRateValueTag("ERE_ResultMessage", "String", "Rate performed OK"));
        buf.append(this.createRateValueTag("Price", "Double", cost + ""));
        buf.append(this.createRateValueTag(ATTR_DURATION, "Integer", duration + ""));
    }

    private StringBuffer performRate(Node rateDetails) throws Exception {
        StringBuffer buffer = new StringBuffer();
        boolean trace = false;
        String serviceProviderName = EmmRateAction.getAttribute(ATTR_SERVICEPROVIDER, rateDetails);
        String ratingPlanName = EmmRateAction.getAttribute(ATTR_RATINGPLAN, rateDetails);
        String date = EmmRateAction.getAttribute(ATTR_DATE, rateDetails);
        String duration = EmmRateAction.getAttribute(ATTR_DURATION, rateDetails);
        String maxCost = EmmRateAction.getAttribute(ATTR_COST, rateDetails);
        trace = this.getOptionalBooleanAttribute("Trace", rateDetails);
        ServiceProvider serviceProvider = this.myEreManager.getServiceProvider(serviceProviderName);
        if (serviceProvider == null) {
            throw new Exception("ServiceProvider = '" + serviceProviderName + "' is missing");
        }
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan == null) {
            throw new Exception("RatingPlan = '" + ratingPlanName + "' is missing");
        }
        try {
            this.myEreManager.getService(ratingPlan.getService().getId());
        }
        catch (Exception e) {
            throw new Exception("No service for " + ratingPlan.getName());
        }
        Service service = ratingPlan.getService();
        List<Node> parameters = this.getParameters(rateDetails);
        if (service.getClassRepository().isUsingDataSet()) {
            this.rateR5(buffer, date, duration, maxCost, trace, ratingPlan, service, parameters);
        } else {
            this.rateR3(buffer, date, duration, maxCost, trace, serviceProvider, ratingPlan, parameters);
        }
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rateR5(StringBuffer buffer, String date, String duration, String cost, boolean trace, RatingPlan ratingPlan, Service service, List<Node> parameters) throws Exception, RatingException {
        RatingDataSet dataset = (RatingDataSet)this.myEreManager.getService(service.getId()).getDataSet();
        long durLong = Long.parseLong(duration) / 1000L;
        this.fillRatingDataSet(dataset, parameters, service.getId());
        ContinuousTimeTask theTask = dataset instanceof MillisecondAllocatableRatingDataSet ? new ContinuousMillisecondTimeTask(Long.parseLong(duration)) : new ContinuousTimeTask(durLong);
        dataset.setMaxCost(new RatingDecimal(EreDefs.monetaryUnitStringToDouble(cost)));
        theTask.setDataSet(dataset);
        dataset.setTreeTask(theTask);
        theTask.resetModified();
        Calendar startTime = DateUtil.parse(date);
        String traceText = null;
        try {
            if (trace) {
                TraceTreeExecutor exec = new TraceTreeExecutor(dataset.getTreeExecutor());
                dataset.setTreeExecutor(exec);
                dataset.setCurrentTime(startTime);
                DataSet preDataSet = (DataSet)dataset.clone();
                dataset.execute(ratingPlan, startTime);
                traceText = exec.getTraceData().getTraceAsString(preDataSet, dataset);
            } else {
                dataset.execute(ratingPlan, startTime);
            }
        }
        catch (NoTreeFoundException ex) {
            throw new RatingException(7, EreDefs.getErrorString("error.noValidPeriod") + "start time " + DateUtil.formatISODateTime(startTime, false));
        }
        if (!dataset.hasModifierBeenExecuted()) throw new Exception("[0] No modifier was found");
        if (theTask.getRemainingDuration() != 0L && theTask.getAllocatedDuration() <= 0L) throw new Exception(MSG_NOT_ENOUGH_MONEY);
        this.addSuccessMessage(buffer, dataset.getCost().doubleValue(), theTask.getAllocatedDuration());
        this.includeResponse(service, buffer, dataset);
        if (!trace || traceText == null) return;
        buffer.append("<Trace>").append(traceText).append("</Trace>");
    }

    private void rateR3(StringBuffer buffer, String date, String duration, String cost, boolean trace, ServiceProvider serviceProvider, RatingPlan ratingPlan, List<Node> parameters) throws Exception {
        RateTracer tracer = null;
        RatingData ratingData = this.myEreManager.getService(ratingPlan.getService().getId()).getRatingData();
        ratingData.reset();
        if (trace) {
            tracer = new RateTracer();
            ratingData.setTrace(tracer);
        } else {
            ratingData.setTrace(null);
        }
        this.fillRatingData(ratingData, parameters, ratingPlan.getService().getId());
        ratingData.rate(serviceProvider, ratingPlan, date, duration, cost);
        if (ratingData.timeLeft == 0L && Long.parseLong(ratingData.getGrantedTime()) == 0L) {
            throw new Exception(MSG_NOT_ENOUGH_MONEY);
        }
        if (!ratingData.hasRated) {
            throw new Exception("Rating case not rated ...");
        }
        long resultDuration = ratingData.currentDuration - ratingData.accumulatedDuration;
        this.addSuccessMessage(buffer, ratingData.totalCost, resultDuration);
        this.includeResponse(ratingPlan.getService(), buffer, ratingData);
        if (trace && tracer != null) {
            buffer.append("<Trace>" + tracer.getTraceBuffer().toString() + "</Trace>");
        }
    }

    private List<Node> getParameters(Node rateDetails) throws Exception {
        Element cdrElement;
        List<Node> parameters = null;
        Element calldatarecordElement = XMLUtil.getFirstElementNamed(TAG_CALLDATARECORD, (Element)rateDetails);
        if (calldatarecordElement != null && (cdrElement = XMLUtil.getFirstElementNamed(TAG_CDR, calldatarecordElement)) != null) {
            parameters = XMLUtil.getElementChildren(cdrElement);
        }
        if (parameters == null) {
            throw new Exception("NO parameters found ");
        }
        return parameters;
    }

    private String createRateValueTag(String name, String type, String value) {
        return "<RateValue Name=\"" + name + "\" " + ATTR_TYPE + "=\"" + type + "\" " + ATTR_VALUE + "=\"" + XMLUtil.escape(value) + "\"/>\n";
    }

    private Object getValueFromDataSet(DataSet dataset, FieldDefinition def) {
        Object value = null;
        if (def == null) {
            return null;
        }
        DataSetField dataSetField = new DataSetField(def);
        if (dataSetField.doesDataExistInDataSet(dataset)) {
            value = dataSetField.getValueFromDataSet(dataset);
        }
        return value;
    }

    private String makeStringFromArray(Map<Integer, Object> arrayAsMap, ValueResolver resolver) {
        String string = "";
        if (arrayAsMap != null) {
            StringBuilder builder = new StringBuilder();
            for (Object obj : arrayAsMap.values()) {
                builder.append(resolver.makeValueString(obj)).append(",");
            }
            string = builder.toString();
        }
        return string;
    }

    private void includeResponse(Service service, StringBuffer buffer, DataSet dataset) {
        ClassRepository repository = service.getClassRepository();
        for (FieldDefinition field : repository.getFieldDefinitions()) {
            String valueString;
            Object value = this.getValueFromDataSet(dataset, field);
            if (!"VARIABLE".equals(field.getParameterType()) || value == null) continue;
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(repository, field);
            String typeName = field.getTypedDataType().getTypeName();
            if (field.isArray() && value.getClass().isArray()) {
                valueString = this.makeStringFromArray(DataSetArrayHelper.convertArrayToMap(value), resolver);
                typeName = typeName + "[]";
            } else {
                valueString = resolver.makeValueString(value);
            }
            String rv = this.createRateValueTag(field.getFieldName(), typeName, valueString);
            buffer.append(rv);
        }
    }

    private void includeResponse(Service service, StringBuffer buffer, RatingData ratingData) {
        Enumeration<?> keys = ratingData.keys();
        while (keys.hasMoreElements()) {
            Object currentElement = keys.nextElement();
            RatingDataField currentField = ratingData.getRatingDataFieldByName((String)currentElement);
            FieldDefinition definition = this.myEreManager.getService(service.getId()).getClassRepository().getFieldDefinitionByName(currentField.toString());
            if (!"VARIABLE".equalsIgnoreCase(definition.getParameterType())) continue;
            String[] values = currentField.getValueArray();
            if (values.length == 1) {
                String rv = this.createRateValueTag(currentField.toString(), currentField.getDataType(), values[0]);
                buffer.append(rv);
                continue;
            }
            if (values.length <= 1) continue;
            StringBuffer tmpBuffer = new StringBuffer();
            tmpBuffer.delete(0, tmpBuffer.length());
            for (int i = 0; i < values.length; ++i) {
                tmpBuffer.append(values[i] + ',');
            }
            String rv = this.createRateValueTag(currentField.toString(), currentField.getDataType(), tmpBuffer.toString());
            buffer.append(rv);
        }
    }

    private void fillRatingDataSet(DataSet dataset, List<Node> parameter, String serviceName) throws Exception {
        Object value;
        ClassRepository repository = this.myEreManager.getService(serviceName).getClassRepository();
        for (Node child : parameter) {
            String name = child.getNodeName();
            value = XMLUtil.getFirstTextContent(child);
            FieldDefinition field = repository.getFieldDefinitionByName(name);
            if (field == null) {
                throw new Exception("Referred field '" + name + "' does not exist in the service '" + serviceName + "'.");
            }
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(repository, field);
            DataSetField dataSetField = new DataSetField(field.getFieldName(), field.getTagNumber(), field.usesTagNumber());
            dataSetField.setValueInDataSet(dataset, resolver.parseValueString((String)value));
        }
        for (FieldDefinition d : repository.getFieldDefinitions()) {
            if (this.getValueFromDataSet(dataset, d) != null) continue;
            if (d.isMandatory()) {
                throw new Exception("Mandatory field '" + d.getFieldName() + "' missing.");
            }
            if (!d.hasDefaultValue()) continue;
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(repository, d);
            value = d.isArray() ? DataType.parseMultiString(d.getDefaultValue(), resolver) : resolver.createDefaultInstance();
            DataSetField dataSetField = new DataSetField(d.getFieldName(), d.getTagNumber(), d.usesTagNumber());
            dataSetField.setValueInDataSet(dataset, value);
        }
    }

    private void fillRatingData(RatingData ratingData, List<Node> parameters, String serviceName) throws Exception {
        EreManager myManager = this.myEreManager;
        boolean mandatoryFlag = true;
        Enumeration<?> inputIterator = ratingData.keys();
        ClassRepository myRepository = myManager.getService(serviceName).getClassRepository();
        while (inputIterator.hasMoreElements()) {
            String currentValue = null;
            String currentKey = (String)inputIterator.nextElement();
            RatingDataField field = ratingData.getRatingDataFieldByName(currentKey);
            Node valueNode = null;
            for (Node node : parameters) {
                if (!node.getNodeName().equalsIgnoreCase(currentKey)) continue;
                valueNode = node;
                break;
            }
            if (valueNode != null) {
                currentValue = XMLUtil.getFirstTextContent(valueNode);
            }
            if (mandatoryFlag) {
                FieldDefinition definition = myRepository.getFieldDefinitionByName(currentKey);
                if (definition.isMandatory()) {
                    if (currentValue == null) {
                        throw new Exception("Mandatory field '" + currentKey + "' missing.");
                    }
                    field.setValues(field.getType(), new String[]{currentValue});
                    continue;
                }
                if (currentValue == null) continue;
                field.setValues(field.getType(), new String[]{currentValue});
                continue;
            }
            if (currentValue == null) continue;
            field.setValues(field.getType(), new String[]{currentValue});
        }
    }

    private boolean getOptionalBooleanAttribute(String attribute, Node theNode) {
        boolean retBoolean = false;
        Element node = (Element)theNode;
        retBoolean = node.getAttributes().getNamedItem(attribute) == null ? false : node.getAttributes().getNamedItem(attribute).getNodeValue().equalsIgnoreCase("yes");
        return retBoolean;
    }
}

