/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingperiod.action;

import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.ratingperiod.action.RatingPeriodAction;
import ericsson.ere.integration.management.ratingperiod.action.RatingPeriodSetAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.Calendar;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RatingPeriodSetPropertyAction
extends RatingPeriodAction
implements EreAction {
    @Override
    public String perform(NodeList config) throws Exception {
        String response = "";
        RatingPeriod ratingPeriod = null;
        Element propertyElement = XMLUtil.getNamedElement("Property", config);
        Element valueElement = XMLUtil.getNamedElement("NewValues", config);
        try {
            ratingPeriod = RatingPeriodAction.getRatingPeriod(config, this.getEreManager());
        }
        catch (Exception e) {
            response = RatingPeriodSetPropertyAction.createErrorTag(e.getMessage());
        }
        if (ratingPeriod != null) {
            if (propertyElement == null) {
                response = RatingPeriodSetPropertyAction.createErrorTag("Invalid request, properties to set not correctly defined.");
            } else if (valueElement == null) {
                response = RatingPeriodSetPropertyAction.createErrorTag("Invalid request, values to set not correctly defined.");
            } else {
                RatingPeriodSetAction.removePeriodFromPropertyContainer(this.getEreManager(), ratingPeriod);
                String keyString = propertyElement.getAttribute("key");
                String[] keys = StringUtil.splitSemiColonSeparatedString(keyString);
                String valueString = valueElement.getAttribute("value");
                String[] values = StringUtil.splitSemiColonSeparatedString(valueString);
                if (keys.length != values.length) {
                    response = RatingPeriodSetPropertyAction.createErrorTag("Invalid request");
                } else {
                    try {
                        Calendar modifiedDate = Calendar.getInstance();
                        Element newConfig = this.updatePeriodWithProperties(keys, values, ratingPeriod, modifiedDate);
                        String newVersion = this.updateVersion(ratingPeriod, newConfig, modifiedDate);
                        String newFileName = RatingPeriodSetPropertyAction.writeRatingPeriodConfigToFile(ratingPeriod, newConfig);
                        ratingPeriod.update(newFileName, newVersion, modifiedDate, newConfig);
                    }
                    catch (Exception e) {
                        response = RatingPeriodSetPropertyAction.createErrorTag(e.getMessage());
                    }
                }
            }
        }
        return response;
    }

    private String updateVersion(RatingPeriod period, Element config, Calendar modifiedDate) {
        Element versionElement = XMLUtil.getFirstElementNamed("Version", config);
        String newVersionString = "";
        if (versionElement != null) {
            String currentVersion = versionElement.getAttribute("version");
            Long newVersion = Long.parseLong(currentVersion) + 1L;
            newVersionString = newVersion.toString();
            RatingPeriodAction.updateVersion(versionElement, modifiedDate, newVersionString);
            period.setLastModified(modifiedDate);
        }
        return newVersionString;
    }

    private Element updatePeriodWithProperties(String[] keys, String[] values, RatingPeriod period, Calendar modifiedDate) throws Exception {
        Element currentConfig = this.getCurrentConfig(period);
        for (int i = 0; i < keys.length; ++i) {
            if ("RatingPeriod_Name_Property".equals(keys[i])) {
                String newName = values[i];
                RatingPeriodAction.updatePeriodNameInStructure(currentConfig, newName);
                period.setName(newName);
                continue;
            }
            if (!"RatingPeriod_StartTime_Property".equals(keys[i])) continue;
            String newStartDate = values[i];
            Calendar newStartTime = DateUtil.parse(newStartDate);
            period.replan(newStartTime, modifiedDate);
        }
        return currentConfig;
    }

    private Element getCurrentConfig(RatingPeriod period) throws Exception {
        String defFileName = period.getActiveFileName();
        String absoluteFilePath = null;
        try {
            absoluteFilePath = WorkingDirHelper.checkFile(defFileName);
            String currentConfig = FileHandling.fileToStringBuffer(absoluteFilePath).toString();
            return XMLUtil.buildDocumentFromString(currentConfig).getDocumentElement();
        }
        catch (Exception e) {
            throw new Exception("Configuration could not be read from file: " + absoluteFilePath + ", error: " + e.getMessage());
        }
    }
}

