/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.service.action;

import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.service.action.ServiceAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceCreateAction
extends ServiceAction
implements EreAction {
    @Override
    public String perform(NodeList actionSettings) throws Exception {
        StringBuffer buffer = new StringBuffer("");
        for (int ii = 0; ii < actionSettings.getLength(); ++ii) {
            try {
                if (actionSettings.item(ii).getNodeType() != 1 || !actionSettings.item(ii).getNodeName().equals(TAG_SERVICE)) continue;
                Service service = this.createService(actionSettings.item(ii));
                service.setConditionsFileName(null);
                this.getEreManager().addService(service.getId(), service);
                service = this.getEreManager().getService(service.getId());
                service.setConditionsFileName(null);
                try {
                    Element serviceDefinitionElement = XMLUtil.getNamedElement(TAG_SERVICEDEFINITION, ((Element)actionSettings.item(ii)).getElementsByTagName(TAG_SERVICEDEFINITION));
                    service.startService(serviceDefinitionElement);
                    buffer.append(WorkingDirHelper.createServiceXML("", service, false, true));
                    continue;
                }
                catch (Exception e) {
                    this.getEreManager().removeService(service.getId());
                    throw new Exception("Failed to start service " + service.getId() + " due to " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                buffer.append(ServiceCreateAction.createErrorTag(e.getMessage()));
            }
        }
        return buffer.toString();
    }
}

