/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.service.action;

import com.ericsson.ere.util.ReadUntilDataCollector;
import com.ericsson.ere.util.ReadUntilParser;
import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.service.action.ServiceAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.Service;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class ServiceGetPropertyAction
extends ServiceAction
implements EreAction {
    @Override
    public String perform(NodeList config) throws Exception {
        String response = "";
        try {
            Element serviceElement = XMLUtil.getNamedElement(TAG_SERVICE, config);
            Element propertyElement = XMLUtil.getNamedElement("Property", config);
            if (serviceElement != null && propertyElement != null) {
                String serviceName = serviceElement.getAttribute("Name");
                String keyString = propertyElement.getAttribute("key");
                String[] keys = StringUtil.splitSemiColonSeparatedString(keyString);
                Service service = this.getEreManager().getService(serviceName);
                if (service == null) {
                    response = ServiceGetPropertyAction.createErrorTag("The service " + serviceName + " does not exist in the ERE Manager");
                } else {
                    String[] properties = this.getEreManager().getPropertyContainer().getPropertyValues(keys).forService(serviceName);
                    if (StringUtil.containsNullValue(properties)) {
                        properties = this.getPropertiesFromFile(service, keys);
                    }
                    response = WorkingDirHelper.createServicePropertyResponseXML("    ", serviceName, keys, properties);
                }
            }
        }
        catch (Exception e) {
            response = ServiceGetPropertyAction.createErrorTag(e.getMessage());
        }
        return response;
    }

    private String[] getPropertiesFromFile(Service service, String[] keys) throws Exception {
        String[] properties = null;
        String defFileName = service.getDefinitionFileName();
        String absoluteFilePath = WorkingDirHelper.checkFile(defFileName);
        String def = FileHandling.fileToStringBuffer(absoluteFilePath).toString();
        if (def != null) {
            String[] collectedProperties = this.collectPropertiesFromFile(def);
            String createdDateString = collectedProperties[0];
            String savedDateString = collectedProperties[1];
            String name = service.getId();
            properties = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if ("Service_Name_Property".equals(key)) {
                    properties[i] = name;
                    continue;
                }
                if ("Service_FileName_Property".equals(key)) {
                    properties[i] = service.getDefinitionFileName();
                    continue;
                }
                if ("Service_ModifiedDate_Property".equals(key)) {
                    properties[i] = savedDateString;
                    continue;
                }
                if (!"Service_CreatedDate_Property".equals(key)) continue;
                properties[i] = createdDateString;
            }
            this.setPropertiesInPropertyContainer(name, defFileName, createdDateString, savedDateString);
        }
        return properties;
    }

    private void setPropertiesInPropertyContainer(String name, String fileName, String modifiedDate, String createdDate) {
        String[] keys = new String[]{"Service_Name_Property", "Service_FileName_Property", "Service_ModifiedDate_Property", "Service_CreatedDate_Property"};
        String[] values = new String[]{name, fileName, modifiedDate, createdDate};
        this.getEreManager().getPropertyContainer().setPropertyValues(keys, values).forService(name);
    }

    private String[] collectPropertiesFromFile(String config) {
        String[] propertiesToCollect = new String[2];
        ServiceDataCollector collector = new ServiceDataCollector();
        try {
            ReadUntilParser parser = new ReadUntilParser(collector);
            parser.parseString(config);
        }
        catch (Exception exception) {
            // empty catch block
        }
        propertiesToCollect[0] = collector.getCreatedDate();
        propertiesToCollect[1] = collector.getSavedDate();
        return propertiesToCollect;
    }

    class ServiceDataCollector
    implements ReadUntilDataCollector {
        private static final String CREATED_DATE_ATTR = "CreatedDate";
        private static final String SAVED_DATE_ATTR = "SavedDate";
        private String[] myElementNamesToCollect = new String[]{"CreatedDate", "SavedDate"};
        private String mySavedDate = null;
        private String myCreatedDate = null;
        private boolean myShouldStop = false;

        ServiceDataCollector() {
        }

        @Override
        public boolean shouldCollectElement(String qName) {
            if ("Settings".equals(qName)) {
                this.myShouldStop = true;
            }
            return this.myElementNamesToCollect[0].equals(qName) || this.myElementNamesToCollect[1].equals(qName);
        }

        @Override
        public boolean shouldStopReading() {
            return this.myShouldStop;
        }

        @Override
        public void collectAttributes(String qName, Attributes attributes) {
            if (CREATED_DATE_ATTR.equals(qName)) {
                this.myCreatedDate = this.getDateAttr(attributes);
            } else if (SAVED_DATE_ATTR.equals(qName)) {
                this.mySavedDate = this.getDateAttr(attributes);
            }
            if (this.mySavedDate != null && this.myCreatedDate != null) {
                this.myShouldStop = true;
            }
        }

        private String getDateAttr(Attributes attributes) {
            String dateAttr = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                if (!"date".equals(attrName)) continue;
                dateAttr = attributes.getValue(i);
            }
            return dateAttr;
        }

        String getSavedDate() {
            return this.mySavedDate;
        }

        String getCreatedDate() {
            return this.myCreatedDate;
        }

        @Override
        public void collectElementTextValue(String qName, String elementValue) {
        }
    }
}

