/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.service.action;

import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.service.action.ServiceAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.Service;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.Calendar;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceSetPropertyAction
extends ServiceAction
implements EreAction {
    @Override
    public String perform(NodeList config) throws Exception {
        Element valueElement;
        Element propertyElement;
        String response = "";
        Element serviceElement = XMLUtil.getNamedElement(TAG_SERVICE, config);
        if (this.allElementsPresent(serviceElement, propertyElement = XMLUtil.getNamedElement("Property", config), valueElement = XMLUtil.getNamedElement("NewValues", config))) {
            String serviceName = serviceElement.getAttribute("Name");
            Service service = this.getEreManager().getService(serviceName);
            if (service == null) {
                response = ServiceSetPropertyAction.createErrorTag("The service " + serviceName + " does not exist in the ERE Manager");
            } else {
                try {
                    this.getEreManager().getPropertyContainer().forgetService(serviceName);
                    String keyString = propertyElement.getAttribute("key");
                    String[] keys = StringUtil.splitSemiColonSeparatedString(keyString);
                    String valueString = valueElement.getAttribute("value");
                    String[] values = StringUtil.splitSemiColonSeparatedString(valueString);
                    String newName = this.findNameValue(keys, values);
                    Element currentConfigElement = this.getCurrentConfig(service);
                    if (newName != null) {
                        currentConfigElement.setAttribute("Service", newName);
                        Element savedDateElement = XMLUtil.getFirstElementNamed("SavedDate", currentConfigElement);
                        Calendar now = Calendar.getInstance();
                        service.setLastModified(now);
                        savedDateElement.setAttribute("date", DateUtil.formatISODateTime(now, false));
                    }
                    this.setService(currentConfigElement, serviceName, newName, service.getDefinitionFileName());
                }
                catch (Exception e) {
                    response = ServiceSetPropertyAction.createErrorTag("Error when creating new configuration for " + serviceName + ": " + e.getMessage());
                }
            }
        }
        return response;
    }

    private boolean allElementsPresent(Element serviceElement, Element propertyElement, Element valueElement) {
        return serviceElement != null && propertyElement != null && valueElement != null;
    }

    private Element getCurrentConfig(Service service) throws Exception {
        String defFileName = service.getDefinitionFileName();
        String absoluteFilePath = WorkingDirHelper.checkFile(defFileName);
        String currentConfig = FileHandling.fileToStringBuffer(absoluteFilePath).toString();
        if (currentConfig != null) {
            return XMLUtil.buildDocumentFromString(currentConfig).getDocumentElement();
        }
        throw new Exception("Configuration could not be read.");
    }

    private String findNameValue(String[] keys, String[] values) {
        String name = null;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!"Service_Name_Property".equals(key)) continue;
            name = values[i];
            break;
        }
        return name;
    }
}

