/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.session.action;

import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.receiver.session.Session;
import java.util.Iterator;
import org.w3c.dom.Node;

public class SessionAction
extends AbstractAction {
    public static String TAG_USER = "User";
    public static String TAG_SETTINGS = "Settings";

    public String createSession(Node sessionNode) throws Exception {
        String user = SessionAction.getAttribute("Name", sessionNode);
        String pwd = SessionAction.getAttribute("Pwd", sessionNode);
        String node = SessionAction.getAttribute("Node", sessionNode);
        return "<SessionId>" + this.getSessionHandler().createSession(user, pwd, node) + "</SessionId>";
    }

    public String listSessions(Node sessionNode) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> sessions = this.getSessionHandler().getSessions();
        while (sessions.hasNext()) {
            Session currentSession = this.getSessionHandler().getSession(sessions.next());
            buffer.append("<Session user=\"" + currentSession.getUser() + "\" " + "SessionId" + "=\"" + currentSession.getSessionId() + "\" EndTime=\"" + currentSession.getEndTime() + "\"/>\n");
        }
        return buffer.toString();
    }

    public String deleteSession(Node sessionNode) throws Exception {
        String sessionId = SessionAction.getAttribute("SessionId", sessionNode.getParentNode());
        this.getSessionHandler().removeSession(sessionId);
        return " SessionId =  " + sessionId + " removed";
    }

    public String setSession(Node sessionNode) throws Exception {
        try {
            String sleepTime = SessionAction.getAttribute("SleepTime", sessionNode);
            this.getSessionHandler().setSleepTime(Integer.parseInt(sleepTime));
        }
        catch (NumberFormatException nf) {
            throw new Exception("SleepTime attribute must be a number");
        }
        catch (Exception nf) {
            // empty catch block
        }
        try {
            String sessionTime = SessionAction.getAttribute("SessionTime", sessionNode);
            this.getSessionHandler().setSessionTime(Integer.parseInt(sessionTime));
        }
        catch (NumberFormatException nf) {
            throw new Exception("SessionTime attribute must be a number");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

