/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class PropertyContainer {
    private Map<PeriodKey, Map<String, String>> myPeriodPropertyContainer = new HashMap<PeriodKey, Map<String, String>>();
    private Map<ServiceKey, Map<String, String>> myServicePropertyContainer = new HashMap<ServiceKey, Map<String, String>>();

    public void forgetPeriod(RatingPeriod period) {
        PeriodKey periodKey = this.createPeriodKey(period.getServiceProviderName(), period.getRatingPlanId(), period.getName(), DateUtil.formatISODateTime(period.getStartTime(), false));
        this.myPeriodPropertyContainer.remove(periodKey);
    }

    public void forgetService(String serviceName) {
        ServiceKey service = new ServiceKey(serviceName);
        this.myServicePropertyContainer.remove(service);
    }

    public PropertySetter setPropertyValues(String[] keys, String[] values) {
        if (StringUtil.containsNullValue(keys)) {
            throw new IllegalArgumentException("All keys must be non-null.");
        }
        return new PropertySetter(keys, values);
    }

    public PropertyFetcher getPropertyValues(String[] keys) {
        if (StringUtil.containsNullValue(keys)) {
            throw new IllegalArgumentException("All keys must be non-null.");
        }
        return new PropertyFetcher(keys);
    }

    private PeriodKey createPeriodKey(String providerName, String planName, String periodName, String startDate) {
        return new PeriodKey(providerName, planName, periodName, startDate);
    }

    private static void checkPeriodParameters(String providerName, String planName, String periodName, String startDateInISO) {
        if (!(PropertyContainer.isValidValue(providerName) && PropertyContainer.isValidValue(planName) && PropertyContainer.isValidValue(periodName) && PropertyContainer.isValidValue(startDateInISO))) {
            throw new IllegalArgumentException("Must provide a valid value for all identifiers of a rating period.");
        }
    }

    private static boolean isValidValue(String value) {
        return value != null && value.length() > 0;
    }

    @Immutable
    private class PeriodKey {
        private final String myProviderName;
        private final String myPlanName;
        private final String myPeriodName;
        private final String myStartDate;

        public PeriodKey(String providerName, String planName, String periodName, String startDateInISO) {
            PropertyContainer.checkPeriodParameters(providerName, planName, periodName, startDateInISO);
            this.myProviderName = providerName;
            this.myPlanName = planName;
            this.myPeriodName = periodName;
            this.myStartDate = startDateInISO;
        }

        public String getPeriodName() {
            return this.myPeriodName;
        }

        public String getPeriodStartTime() {
            return this.myStartDate;
        }

        public String getPlanName() {
            return this.myPlanName;
        }

        public String getProviderName() {
            return this.myProviderName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myPeriodName == null ? 0 : this.myPeriodName.hashCode());
            result = 31 * result + (this.myPlanName == null ? 0 : this.myPlanName.hashCode());
            result = 31 * result + (this.myProviderName == null ? 0 : this.myProviderName.hashCode());
            result = 31 * result + (this.myStartDate == null ? 0 : this.myStartDate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeriodKey other = (PeriodKey)obj;
            if (this.myPeriodName == null ? other.myPeriodName != null : !this.myPeriodName.equals(other.myPeriodName)) {
                return false;
            }
            if (this.myPlanName == null ? other.myPlanName != null : !this.myPlanName.equals(other.myPlanName)) {
                return false;
            }
            if (this.myProviderName == null ? other.myProviderName != null : !this.myProviderName.equals(other.myProviderName)) {
                return false;
            }
            return !(this.myStartDate == null ? other.myStartDate != null : !this.myStartDate.equals(other.myStartDate));
        }
    }

    @Immutable
    private class ServiceKey {
        private final String myName;

        public ServiceKey(String serviceName) {
            if (serviceName == null || serviceName.length() == 0) {
                throw new IllegalArgumentException("Service name must be provided.");
            }
            this.myName = serviceName;
        }

        public String getName() {
            return this.myName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceKey other = (ServiceKey)obj;
            return !(this.myName == null ? other.myName != null : !this.myName.equals(other.myName));
        }
    }

    public class PropertySetter {
        private String[] myCurrentValuesToSet;
        private String[] myCurrentKeysToSet;

        PropertySetter(String[] keys, String[] values) {
            this.myCurrentKeysToSet = keys;
            this.myCurrentValuesToSet = values;
        }

        public void forPeriod(String providerName, String planName, String periodName, String startDate) {
            PeriodKey period = PropertyContainer.this.createPeriodKey(providerName, planName, periodName, startDate);
            this.setPeriodProperties(period);
        }

        public void forService(String serviceName) {
            ServiceKey service = new ServiceKey(serviceName);
            this.setServiceProperties(service);
        }

        private void setServiceProperties(ServiceKey service) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (int i = 0; i < this.myCurrentKeysToSet.length; ++i) {
                valueMap.put(this.myCurrentKeysToSet[i], this.myCurrentValuesToSet[i]);
            }
            ServiceKey newServiceInfo = this.updateServiceInfoIfNecessary(service, valueMap);
            if (newServiceInfo != null) {
                PropertyContainer.this.myServicePropertyContainer.remove(service);
                PropertyContainer.this.myServicePropertyContainer.put(newServiceInfo, valueMap);
            } else {
                PropertyContainer.this.myServicePropertyContainer.put(service, valueMap);
            }
        }

        private ServiceKey updateServiceInfoIfNecessary(ServiceKey service, Map<String, String> valueMap) {
            ServiceKey newServiceInfo = null;
            String newName = null;
            newName = valueMap.get("Service_Name_Property");
            if (newName != null && !newName.equals(service.getName())) {
                newServiceInfo = new ServiceKey(newName);
            }
            return newServiceInfo;
        }

        private void setPeriodProperties(PeriodKey period) {
            HashMap<String, String> valueMapForPeriod = new HashMap<String, String>();
            for (int i = 0; i < this.myCurrentKeysToSet.length; ++i) {
                valueMapForPeriod.put(this.myCurrentKeysToSet[i], this.myCurrentValuesToSet[i]);
            }
            PeriodKey newPeriodKey = this.updatePeriodInfoIfNecessary(period, valueMapForPeriod);
            if (newPeriodKey != null) {
                PropertyContainer.this.myPeriodPropertyContainer.remove(period);
                PropertyContainer.this.myPeriodPropertyContainer.put(newPeriodKey, valueMapForPeriod);
            } else {
                PropertyContainer.this.myPeriodPropertyContainer.put(period, valueMapForPeriod);
            }
        }

        private PeriodKey updatePeriodInfoIfNecessary(PeriodKey period, Map<String, String> valueMap) {
            PeriodKey newPeriodInfo = null;
            String newName = valueMap.get("RatingPeriod_Name_Property");
            String newStartTime = valueMap.get("RatingPeriod_StartTime_Property");
            if (newName != null || newStartTime != null) {
                String name = newName != null ? newName : period.getPeriodName();
                String startTime = newStartTime != null ? newStartTime : period.getPeriodStartTime();
                newPeriodInfo = new PeriodKey(period.getProviderName(), period.getPlanName(), name, startTime);
            }
            return newPeriodInfo;
        }
    }

    public class PropertyFetcher {
        private String[] myCurrentKeysToFetch;

        PropertyFetcher(String[] keysToFetch) {
            this.myCurrentKeysToFetch = keysToFetch;
        }

        public String[] forPeriod(String providerName, String planName, String periodName, String startDate) {
            PeriodKey period = PropertyContainer.this.createPeriodKey(providerName, planName, periodName, startDate);
            Map<String, String> valueMap = this.getPeriodValueMap(period);
            return this.getProperties(valueMap);
        }

        public String[] forService(String serviceName) {
            ServiceKey service = new ServiceKey(serviceName);
            Map<String, String> valueMap = this.getServiceValueMap(service);
            return this.getProperties(valueMap);
        }

        private String[] getProperties(Map<String, String> valueMap) {
            String[] resultingValues = null;
            if (valueMap != null) {
                resultingValues = new String[this.myCurrentKeysToFetch.length];
                for (int i = 0; i < this.myCurrentKeysToFetch.length; ++i) {
                    resultingValues[i] = valueMap.get(this.myCurrentKeysToFetch[i]);
                }
            }
            return resultingValues;
        }

        private Map<String, String> getPeriodValueMap(PeriodKey period) {
            return (Map)PropertyContainer.this.myPeriodPropertyContainer.get(period);
        }

        private Map<String, String> getServiceValueMap(ServiceKey service) {
            return (Map)PropertyContainer.this.myServicePropertyContainer.get(service);
        }
    }
}

