/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver;

import ericsson.ere.EreLibLoader;
import ericsson.ere.EreLibLoaderMessengerInterface;
import ericsson.ere.EreManagerLoader;
import ericsson.ere.integration.config.ArgumentHandler;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.integration.receiver.server.ServerInterface;
import ericsson.ere.integration.util.ObjectRepository;
import ericsson.ere.management.EreManager;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PoolServer
implements EreLibLoaderMessengerInterface,
Loggable {
    public static final String TAG_POOL_SERVER = "PoolServer";
    public static final String TAG_SERVER_LIST = "ServerList";
    public static final String TAG_OBJECT_LIST = "ObjectList";
    public static final String TAG_RATING_MANAGER = "RatingManager";
    public static final String TAG_SERVER = "Server";
    EreIntegrationLogInterface myLog = null;
    private EreManager myEreManager = new EreManager();

    public EreManager getEreManager() {
        return this.myEreManager;
    }

    public void init(Element serverConfig) throws ConfigurationException {
        ObjectRepository.getInstance().addObject(TAG_POOL_SERVER, this);
        ObjectRepository.getInstance().setLog(this, serverConfig);
        if (serverConfig.getTagName().equals(TAG_POOL_SERVER)) {
            NodeList serverList;
            NodeList ratingManagerList;
            NodeList objectList = serverConfig.getElementsByTagName(TAG_OBJECT_LIST);
            if (objectList != null && objectList.getLength() > 0 && objectList.item(0) instanceof Element) {
                ObjectRepository.getInstance().addFromXML((Element)objectList.item(0));
            }
            if ((ratingManagerList = serverConfig.getElementsByTagName(TAG_RATING_MANAGER)) != null && ratingManagerList.getLength() > 0 && ratingManagerList.item(0) instanceof Element) {
                try {
                    File file = new File(".");
                    String workingDirectoryStr = file.getAbsolutePath();
                    String ratingManagerFileName = "RatingManager.xml";
                    if (workingDirectoryStr.endsWith(".")) {
                        workingDirectoryStr = workingDirectoryStr.substring(0, workingDirectoryStr.length() - 1);
                    }
                    ArgumentHandler arguments = new ArgumentHandler((Element)ratingManagerList.item(0));
                    String workingDir = (String)arguments.getArgument("WorkingDir");
                    String ratingManagerFile = (String)arguments.getArgument("RatingManagerFile");
                    if (System.getProperty(EreLibLoader.KEY_WORKINGDIRECTORY) == null) {
                        if (workingDir == null || workingDir.length() == 0) {
                            workingDir = workingDirectoryStr;
                        }
                        if (!workingDir.endsWith("\\") && !workingDir.endsWith("/")) {
                            workingDir = workingDir + File.separatorChar;
                        }
                        System.setProperty(EreLibLoader.KEY_WORKINGDIRECTORY, workingDir);
                    }
                    if (System.getProperty("RatingManagerFile") == null) {
                        if (ratingManagerFile == null || ratingManagerFile.length() == 0) {
                            ratingManagerFile = ratingManagerFileName;
                        }
                        System.setProperty("RatingManagerFile", ratingManagerFile);
                    }
                    EreManagerLoader loader = new EreManagerLoader(this.myEreManager);
                    loader.setMessenger(this);
                    ObjectRepository.getInstance().addObject("EreManager", this.myEreManager);
                    try {
                        loader.loadManagerFromXML(null, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Could not start ERE " + e.getMessage());
                        throw new RuntimeException("Could not start ERE: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed to start Rating Manger. Reason: " + e.getMessage());
                }
            }
            if ((serverList = serverConfig.getElementsByTagName(TAG_SERVER_LIST)) != null && serverList.getLength() > 0 && serverList.item(0) instanceof Element) {
                ServerInterface newServer = null;
                serverList = serverList.item(0).getChildNodes();
                for (int j = 0; j < serverList.getLength(); ++j) {
                    if (!(serverList.item(j) instanceof Element)) continue;
                    Element se = (Element)serverList.item(j);
                    try {
                        Object o = ObjectRepository.getInstance().getObject(se);
                        if (o instanceof ServerInterface) {
                            newServer = (ServerInterface)o;
                            newServer.startServer();
                            continue;
                        }
                        System.out.println("Failed to start server. Not a ServerInterface object: " + o.getClass());
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println("Failed to start server. Reason: " + ex.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void setLogg(EreIntegrationLogInterface log) {
        this.myLog = log;
    }

    static void printUsageInfo() {
        System.out.println("PoolServer [-w working_directory] [-r rating_manager_file_name] [-ld logDirectory] [-lf logFile] [-l loglevel] [-h]");
        System.out.println("");
        System.out.println("-w the directory where to find the rating manager file, current directory.");
        System.out.println("-r the filename for the rating manager file, default 'RatingManager.xml'");
        System.out.println("-c file path where to find the configuration for the servers to start");
        System.out.println("-h help information, this information");
    }

    public static void startServers(String requestParserConfigFile) {
        Element serverConfig = null;
        try {
            serverConfig = XMLUtil.buildDocumentFromFile(new File(requestParserConfigFile)).getDocumentElement();
            PoolServer.startServers(serverConfig);
        }
        catch (Exception e) {
            System.out.println("Failed to parse XML file: " + requestParserConfigFile + "\nReason: " + e.getMessage());
            return;
        }
    }

    public static void startServers(Element serverConfig) {
        PoolServer pool = new PoolServer();
        try {
            pool.init(serverConfig);
        }
        catch (Exception e) {
            System.out.println("Falied to start server. Reason: " + e.getMessage());
        }
    }

    public static void startServerEnvironment(String[] args, ProgressIndicator progress) throws RuntimeException {
        File file = new File(".");
        String workingDirectoryStr = null;
        String ratingManagerFileName = null;
        String requestParserConfigFile = null;
        file = null;
        if (args.length > 0) {
            for (int ii = 0; ii < args.length; ++ii) {
                if (args[ii].equalsIgnoreCase("-w")) {
                    if (!(file = new File(args[++ii])).exists()) {
                        throw new RuntimeException("Working dir '" + args[ii] + "' does not exist");
                    }
                    workingDirectoryStr = file.getAbsolutePath() + System.getProperty("file.separator");
                    continue;
                }
                if (args[ii].equalsIgnoreCase("-r")) {
                    ratingManagerFileName = args[++ii];
                    continue;
                }
                if (args[ii].equalsIgnoreCase("-c")) {
                    requestParserConfigFile = args[++ii];
                    continue;
                }
                if (!args[ii].equalsIgnoreCase("-h")) continue;
                PoolServer.printUsageInfo();
            }
        }
        if (workingDirectoryStr != null) {
            System.setProperty(EreLibLoader.KEY_WORKINGDIRECTORY, workingDirectoryStr);
        }
        if (ratingManagerFileName != null) {
            System.setProperty("RatingManagerFile", ratingManagerFileName);
        }
        PoolServer.startServers(requestParserConfigFile);
    }

    @Override
    public void print(int level, String msg) {
        if (this.myLog != null) {
            int l = 5;
            if (level == 2) {
                l = 1;
            } else if (level == 0) {
                l = 3;
            } else if (level == 1) {
                l = 2;
            }
            this.myLog.print(l, msg);
        }
    }

    public static void main(String[] args) {
        try {
            PoolServer.startServerEnvironment(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(9);
        }
    }
}

