/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.sender;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class TestTrafficSender {
    private Socket mySocket = null;
    private String myHost = "localhost";
    private int myPort = 7070;
    private String myUser = "testUser";
    private String myPassword = "testPassword";
    private BufferedOutputStream myOut = null;
    private BufferedInputStream myIn = null;
    private String mySessionId = "0";

    public TestTrafficSender(String host, int port) {
        this.setHost(host);
        this.setPort(port);
        try {
            this.mySocket = new Socket(this.myHost, this.myPort);
            this.mySocket.setTcpNoDelay(true);
            this.myIn = new BufferedInputStream(this.mySocket.getInputStream());
            this.myOut = new BufferedOutputStream(this.mySocket.getOutputStream());
        }
        catch (Exception uhe) {
            System.out.println("Failed to setup socket to : " + host + ":" + port);
            System.out.println("Reason: " + uhe.getMessage());
        }
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public void setUser(String user) {
        this.myUser = user;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    private void sendString(String theString, OutputStream out) throws IOException {
        byte[] data = theString.getBytes();
        byte[] dataSize = new byte[]{(byte)(data.length >> 24), (byte)(data.length >> 16), (byte)(data.length >> 8), (byte)(data.length >> 0)};
        out.write(dataSize);
        out.write(data);
        out.flush();
    }

    public String send(String requestString) {
        String responseLine = "";
        try {
            this.sendString(requestString, this.myOut);
            byte[] sizeBytes = new byte[4];
            this.readDataFromStream(this.myIn, sizeBytes);
            int dataSize = this.sizeToInt(sizeBytes);
            byte[] data = new byte[dataSize];
            this.readDataFromStream(this.myIn, data);
            responseLine = new String(data).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errTxt = "Exception caught in HTTPServerSender.send(String theRequest): \n" + e.getMessage();
            System.out.println("ERROR : " + errTxt);
        }
        return responseLine;
    }

    private void readDataFromStream(InputStream in, byte[] data) throws Exception {
        int left = data.length;
        int offset = 0;
        while (left > 0) {
            int readBytes = in.read(data, offset, left);
            left -= readBytes;
            offset += readBytes;
        }
    }

    private static int getUnsignedByte(byte theByte) {
        int retValue = 0;
        retValue = theByte < 0 ? theByte + 256 : theByte;
        return retValue;
    }

    private int sizeToInt(byte[] size) {
        int retValue = TestTrafficSender.getUnsignedByte(size[0]) * 256 * 256 * 256;
        retValue += TestTrafficSender.getUnsignedByte(size[1]) * 256 * 256;
        retValue += TestTrafficSender.getUnsignedByte(size[2]) * 256;
        if ((retValue += TestTrafficSender.getUnsignedByte(size[3])) < 0) {
            return retValue + Integer.MAX_VALUE;
        }
        return retValue;
    }

    private void login() {
        String loginRequest = "<Request MO=\"Session\" Operation=\"Login\" SessionId=\"0\"> <User Name=\"" + this.myUser + "\" Pwd=\"" + this.myPassword + "\"/> </Request>";
        try {
            String loginResponse = this.send(loginRequest);
            System.out.println(loginResponse);
            int firstPos = loginResponse.indexOf("<SessionId>");
            int lastPos = loginResponse.indexOf("</", firstPos);
            this.mySessionId = firstPos > -1 ? loginResponse.substring(firstPos + "<SessionId>".length(), lastPos) : "Not connected";
            System.out.println("Session Id " + this.mySessionId);
        }
        catch (Exception e) {
            System.out.println("Could not connect to " + this.myHost + ":" + this.myPort + " reason :\n" + e.getMessage());
        }
    }
}

