/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.sender;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.log.DefaultLog;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.sender.ServerSender;
import ericsson.ere.xml.XMLUtil;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRequestSender {
    private static final String DEFAULT_CFG_FILE = "XMLRequestSender.cfg";
    private static final String SERVER_TYPE_TAG = "ServerType";
    private static final String ONE_FILE_FOR_EACH_REQUEST = "@offer@";
    private static final String STDOUT = "stdout";
    private NodeList myConfig = null;
    private String typeOfServer = "";
    private ServerSender myServerSender;
    private EreIntegrationLogInterface _log;

    public XMLRequestSender(String cfgFile) {
        this.readConfig(cfgFile);
        this.setupLogFile();
        try {
            this.typeOfServer = this.getTypeOfServer();
            if (this.useLogg() && this._log.isLevel(3)) {
                this._log.print(3, "Connecting to a " + this.typeOfServer + " server.");
            }
        }
        catch (Exception e) {
            if (this.useLogg() && this._log.isLevel(3)) {
                this._log.print(3, "XMLRequestSender(\"" + cfgFile + "\")-> " + e);
            }
            e.printStackTrace();
            System.exit(0);
        }
        String serverSenderClass = this.typeOfServer + "ServerSender";
        try {
            this.myServerSender = (ServerSender)this.instantiate(serverSenderClass);
            for (int ii = 0; ii < this.myConfig.getLength(); ++ii) {
                if (!this.myConfig.item(ii).getNodeName().equals(SERVER_TYPE_TAG)) continue;
                this.myServerSender.init(this.myConfig.item(ii).getChildNodes());
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }

    private boolean useLogg() {
        return this._log != null;
    }

    private String getTypeOfServer() {
        String retValue = "";
        for (int ii = 0; ii < this.myConfig.getLength(); ++ii) {
            if (!this.myConfig.item(ii).getNodeName().equals(SERVER_TYPE_TAG)) continue;
            retValue = this.myConfig.item(ii).getAttributes().getNamedItem("class").getNodeValue();
            ii = this.myConfig.getLength() + 1;
        }
        return retValue;
    }

    public void connect() {
        try {
            this.myServerSender.connect();
        }
        catch (Exception e) {
            System.err.println("XMLRequestSender.connect() " + e);
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            this.myServerSender.disconnect();
        }
        catch (Exception e) {
            System.err.println("XMLRequestSender.connect() " + e);
            e.printStackTrace();
        }
    }

    public void send(String request) {
        try {
            this.myServerSender.send(request);
        }
        catch (Exception e) {
            System.err.println("Exception in XMLRequestSender.send(FDSNamedValue) : " + e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String requestFile, String responseFile) {
        Document myXMLRequest = null;
        try (FileReader reader = new FileReader(requestFile);){
            myXMLRequest = XMLUtil.buildDocument(reader);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe);
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        try {
            NodeList commandList = myXMLRequest.getDocumentElement().getChildNodes();
            int runningNumber = 0;
            for (int ii = 0; ii < commandList.getLength(); ++ii) {
                Node tmpNode = commandList.item(ii);
                if (tmpNode.getNodeType() != 1) continue;
                if (responseFile.endsWith(ONE_FILE_FOR_EACH_REQUEST)) {
                    String respFile = responseFile.substring(0, responseFile.lastIndexOf(ONE_FILE_FOR_EACH_REQUEST)) + "_" + runningNumber++;
                    if (this.useLogg() && this._log.isLevel(3)) {
                        this._log.print(3, "=======> File to write to " + respFile);
                    }
                }
                this.send(tmpNode.toString());
                String responceDoc = this.getResponse();
                if (!this.useLogg() || !this._log.isLevel(3)) continue;
                this._log.print(3, responceDoc);
            }
        }
        catch (Exception e) {
            System.err.println("XMLRequestSender.send(requestFile,responseFile) " + e);
            e.printStackTrace();
        }
    }

    public String getResponse() {
        String resp = null;
        try {
            resp = this.myServerSender.getResponse();
        }
        catch (Exception e) {
            System.err.println("XMLRequestSender.getResponse() " + e);
            e.printStackTrace();
        }
        return resp;
    }

    public Object instantiate(String className) throws Exception {
        if (this.useLogg() && this._log.isLevel(3)) {
            this._log.print(3, ">>> instantiate(" + className + ")\n");
        }
        Object obj = null;
        try {
            Class<?> theClass = EreClassLoader.getClass(className);
            obj = theClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            String errmsg = "The class '" + className + "' was not found. Details: " + x.toString();
            throw new Exception(errmsg);
        }
        catch (InstantiationException x) {
            String errmsg = "Failed to instatiate object of class: '" + className + "'. Details: " + x.toString();
            throw new Exception(errmsg);
        }
        catch (IllegalAccessException x) {
            String errmsg = "Not allowed to instatiate object of class: '" + className + "'. Details: " + x.toString();
            throw new Exception(errmsg);
        }
        catch (Throwable x) {
            String errmsg = "Error while loading/instatiation of object of class: '" + className + "'. Details: " + x.toString();
            throw new Exception(errmsg);
        }
        if (this.useLogg() && this._log.isLevel(3)) {
            this._log.print(3, "<<< instantiate(" + className + ")\n");
        }
        return obj;
    }

    private void readConfig(String cfgFile) {
        try {
            this.myConfig = XMLUtil.documentFromFile(cfgFile).getDocumentElement().getChildNodes();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe);
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void setupLogFile() {
        try {
            this._log = new DefaultLog(null, null);
            this._log.setLevel(2);
        }
        catch (Throwable x) {
            this._log = new DefaultLog(new PrintWriter(System.err, true));
            if (this.useLogg() && this._log.isLevel(3)) {
                this._log.print(3, "Throwable : " + x);
            }
            x.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("");
        System.err.println("java XMLRequestSender -r request_file [-h] [-c config_file] [-o output_file & -sep] ");
        System.err.println("");
        System.err.println("-r request_file\t mandatory, file containing one or many xml-requests");
        System.err.println("-h \t\t print this help");
        System.err.println("-d \t\t used for debugging (logging to file)");
        System.err.println("-c config_file\t optional, holds information about server, login data etc \n\t\t (if no file specified default file XMLRequestSender.cfg is used)");
        System.err.println("-o output_file\t optional, which file the output (response) is written to \n\t\t (if no file specified stdout is used)");
        System.err.println("-sep \t\t optional (combined with -o), the output (response) from each requests \n\t\t is written to separate files with name specified by -o (or the same \n\t\t name as request_file if -o not specified), plus a 'running' nummer. \n\t\t Overrides output on stdout.");
        System.err.println("");
    }

    public static void main(String[] args) {
        String _cfgFile = DEFAULT_CFG_FILE;
        String _reqFile = null;
        String _outFile = STDOUT;
        try {
            if (args.length == 0) {
                XMLRequestSender.printUsage();
                System.exit(1);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-c")) {
                    _cfgFile = args[++i];
                    System.err.println("Using config file " + _cfgFile);
                    continue;
                }
                if (args[i].equals("-r")) {
                    _reqFile = args[++i];
                    System.err.println("Using request file " + _reqFile);
                    continue;
                }
                if (args[i].equals("-o")) {
                    _outFile = args[++i];
                    System.err.println("Using output file " + _outFile);
                    continue;
                }
                if (args[i].equals("-sep")) {
                    if (_outFile.equals(STDOUT)) {
                        System.err.println("Using output filename " + _reqFile + "_<number>");
                        _outFile = _reqFile;
                    } else {
                        System.err.println("Using separate output filenames " + _outFile + "_<number>");
                    }
                    _outFile = _outFile + ONE_FILE_FOR_EACH_REQUEST;
                    continue;
                }
                if (args[i].equals("-h")) {
                    XMLRequestSender.printUsage();
                    System.exit(0);
                    continue;
                }
                if (!args[i].equals("-d")) continue;
                System.err.println("Debug mode... (logging to logfile)");
            }
        }
        catch (Exception e) {
            System.err.println("Error when reading arguments... " + e.toString());
            System.exit(1);
        }
        try {
            XMLRequestSender myXMLReqSender = new XMLRequestSender(_cfgFile);
            myXMLReqSender.connect();
            if (_reqFile != null) {
                myXMLReqSender.send(_reqFile, _outFile);
            }
            myXMLReqSender.disconnect();
        }
        catch (Exception e) {
            System.err.println("Error in main() " + e);
            e.printStackTrace();
        }
    }
}

