/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.testgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FrameTester
extends JFrame {
    JPanel contentPane;
    JDesktopPane desk;
    int mainScreenWidth = 1000;
    int mainScreenHeight = 1000;
    int mainScreenXLocation = 0;
    int mainScreenYLocation = 0;
    double mainWindowWidth = 0.6;
    double mainWindowHeight = 0.9;

    public FrameTester() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (FrameTester.this.performCorrectExit()) {
                    System.exit(0);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrameTester.this.mainScreenWidth = evt.getComponent().getWidth();
                FrameTester.this.mainScreenHeight = evt.getComponent().getHeight();
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
                FrameTester.this.mainScreenXLocation = evt.getComponent().getX();
                FrameTester.this.mainScreenYLocation = evt.getComponent().getY();
            }
        });
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.setContentPane(this.contentPane);
        this.desk = new JDesktopPane();
        this.desk.setDesktopManager(new DefaultDesktopManager());
        this.getContentPane().add((Component)this.desk, "Center");
        Toolkit tk = this.getToolkit();
        Dimension screenDim = tk.getScreenSize();
        this.mainScreenWidth = (int)((double)screenDim.width * this.mainWindowWidth);
        this.mainScreenHeight = (int)((double)screenDim.height * this.mainWindowHeight);
        this.setSize(this.mainScreenWidth, this.mainScreenHeight);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        Point p = this.getLocationOnScreen();
        this.mainScreenXLocation = (int)p.getX();
        this.mainScreenYLocation = (int)p.getY();
    }

    public boolean performCorrectExit() {
        return true;
    }

    public String serviceXmlRequest(String sessionId, String serviceName) {
        return "<Request MO=\"Service\" Operation=\"Get\" SessionId=\"" + sessionId + "\"><Service Name=\"" + serviceName + "\"/></Request>";
    }

    public String ratingPlanXmlRequest(String sessionId, String serviceProvider, String ratingPlan) {
        return "<Request MO=\"RatingPlan\" Operation=\"Get\" SessionId=\"" + sessionId + "\"><ServiceProvider Name=\"" + serviceProvider + "\"><RatingPlan Name=\"" + ratingPlan + "\"/></ServiceProvider></Request>";
    }

    public String ratingPeriodXmlRequest(String sessionId, String serviceProviderName, String ratingPlanName, String ratingPeriodName) {
        return "<Request MO=\"RatingPeriod\" Operation=\"Get\" SessionId=\"" + sessionId + "\"><ServiceProvider Name=\"" + serviceProviderName + "\"><RatingPlan Name=\"" + ratingPlanName + "\"><RatingPeriod Name=\"" + ratingPeriodName + "\"/></RatingPlan></ServiceProvider></Request>";
    }

    public String getFileXml(String sessionId, String fileName, String dir) {
        String workingDir = "/ws_pkit/rma/";
        return "<Request MO=\"File\" Operation=\"Get\" SessionId=\"" + sessionId + "\"><File Name=\"" + fileName + "\" Dir=\"" + workingDir + dir + "\"/> </Request>";
    }
}

