/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.util;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjectRepository {
    public static final String TAG_OBJECT_LIST = "ObjectList";
    public static final String TAG_OBJECT = "Object";
    public static final String ATTR_CLASS = "Class";
    public static final String ATTR_REFERENCE = "ObjectRef";
    Map<String, Object> myRepository = new HashMap<String, Object>();
    static final ObjectRepository myInstance = new ObjectRepository();

    public static ObjectRepository getInstance() {
        return myInstance;
    }

    public void addObject(String objectRef, Object object) {
        this.myRepository.put(objectRef, object);
    }

    public void addFromXML(Element root) {
        if (root.getTagName().equals(TAG_OBJECT_LIST)) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                Element e = (Element)list.item(i);
                String cname = e.getAttribute(ATTR_CLASS);
                String ref = e.getAttribute(ATTR_REFERENCE);
                if (StringUtil.isEmptyString(cname) || StringUtil.isEmptyString(ref)) continue;
                try {
                    Object object = this.createClassInstance(cname, root, e);
                    this.addObject(ref, object);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Failed to instantiate object: " + ref + " - " + cname + "\nReason:" + ex.getMessage());
                }
            }
        }
    }

    public Object getObject(String objectRef) {
        return this.myRepository.get(objectRef);
    }

    public Object getObject(Element tag) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ConfigurationException {
        Object o = null;
        String cname = tag.getAttribute(ATTR_CLASS);
        String objectRef = tag.getAttribute(ATTR_REFERENCE);
        if (!StringUtil.isEmptyString(objectRef)) {
            o = this.getObject(objectRef);
        }
        if (o == null && !StringUtil.isEmptyString(cname)) {
            o = this.createClassInstance(cname, tag, tag);
            if (!StringUtil.isEmptyString(objectRef)) {
                this.addObject(objectRef, o);
            }
        }
        return o;
    }

    private Object createClassInstance(String className, Element logElem, Element configElem) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ConfigurationException {
        Object o = EreClassLoader.createInstance(className);
        this.setLog(o, logElem);
        if (o instanceof Configurable) {
            ((Configurable)o).init(configElem);
        }
        return o;
    }

    public void setLog(Object o, Element element) {
        Element logElement;
        if (o instanceof Loggable && (logElement = XMLUtil.getNamedElement("Logger", element.getChildNodes())) != null) {
            try {
                Object logObject = this.getObject(logElement);
                if (logObject instanceof EreIntegrationLogInterface) {
                    ((Loggable)o).setLogg((EreIntegrationLogInterface)logObject);
                } else {
                    System.out.println("Faulty configuration. Specified Logger is not of type EreIntegrationLogInterface: " + logObject.getClass());
                    System.out.println("XML Element: " + logElement.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Failed to set logger. Reason: " + e.getMessage());
                System.out.println("XML Element: " + logElement.toString());
            }
        }
    }
}

