/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OneHitFee
extends AbstractModifier {
    double myFee;

    public OneHitFee() {
    }

    public OneHitFee(double aFee) {
        this.myFee = aFee;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        double thePrice = 0.0;
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (!children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                thePrice = Double.parseDouble(value.item(bb).getNodeValue());
            }
        }
        this.myFee = thePrice;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        long temp = Double.doubleToLongBits(this.myFee);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneHitFee other = (OneHitFee)obj;
        return Double.doubleToLongBits(this.myFee) == Double.doubleToLongBits(other.myFee);
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        if (theData.moneyLeft - this.myFee * theData.currentDiscount >= -1.0E-7 || theData.moneyLeft == -1.0) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tOneHitFee Price(" + this.myFee + " * " + theData.currentDiscount + ")");
            }
            theCost.setValue(theCost.value + theData.allocateCost(this.myFee * theData.currentDiscount));
            theTime.setValue(theTime.value + theData.allocateTime(theData.timeLeft));
        } else {
            theTime.setValue(0L);
            theData.timeLeft = 0L;
        }
    }
}

