/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf.bonus;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BonusFee
extends AbstractModifier {
    private double myFee;
    private long myFactor;
    static final String TAG_BONUS_RESULT = "Bonus result";

    public BonusFee(double aFee, long aFactor) {
        this.myFee = aFee;
        this.myFactor = aFactor;
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        if (theData.moneyLeft - this.myFee * theData.currentDiscount >= -1.0E-7 || theData.moneyLeft == -1.0) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tBONUSFEE : " + this.myFee + " * " + theData.currentDiscount);
            }
            theCost.setValue(theCost.value + theData.allocateCost(this.myFee * theData.currentDiscount));
            long currentBonus = (Long)theData.getValueObject("Bonus counter");
            System.out.println("BonusFee.perform: currentBonus before is " + currentBonus);
            System.out.println("BonusFee.perform: currentBonus after is " + (currentBonus += this.myFactor));
            Long newBonus = new Long(currentBonus);
            theData.setFirstField(TAG_BONUS_RESULT, newBonus);
            theData.setFirstField("Bonus counter", newBonus);
            System.out.println("Added new value to RatingData");
        } else {
            theTime.setValue(0L);
            theData.timeLeft = 0L;
        }
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        double thePrice = 0.0;
        long theFactor = 0L;
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = Double.parseDouble(value.item(bb).getNodeValue());
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Factor".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theFactor = Long.parseLong(value.item(bb).getNodeValue());
            }
        }
        this.myFee = thePrice;
        this.myFactor = theFactor;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myFactor ^ this.myFactor >>> 32);
        long temp = Double.doubleToLongBits(this.myFee);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BonusFee other = (BonusFee)obj;
        if (this.myFactor != other.myFactor) {
            return false;
        }
        return Double.doubleToLongBits(this.myFee) == Double.doubleToLongBits(other.myFee);
    }
}

