/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf.distance;

import java.util.StringTokenizer;

public class Distance {
    static final double earthRadiusInKm = 6377.5;

    public double calcDistance(String startLongStr, String startLatStr, String endLongStr, String endLatStr) {
        double startLong = this.posToDegrees(startLongStr);
        double startLat = this.posToDegrees(startLatStr);
        double endLong = this.posToDegrees(endLongStr);
        double endLat = this.posToDegrees(endLatStr);
        double Y = StrictMath.sin(StrictMath.toRadians(endLat)) * StrictMath.sin(StrictMath.toRadians(startLat));
        double Z = StrictMath.cos(StrictMath.toRadians(endLat)) * StrictMath.cos(StrictMath.toRadians(startLat)) * StrictMath.cos(StrictMath.toRadians(endLong - startLong));
        double distance = 6377.5 * StrictMath.acos(Y + Z);
        return distance;
    }

    public double posToDegrees(String pos) {
        String compass;
        StringTokenizer token = new StringTokenizer(pos, ":");
        double degrees = 0.0;
        double minute = 0.0;
        double second = 0.0;
        double corr = 1.0;
        if (token.hasMoreTokens()) {
            degrees = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens()) {
            minute = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens()) {
            second = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens() && (compass = token.nextToken()).equals("W")) {
            corr = -1.0;
        }
        return (degrees + minute / 60.0 + second / 3600.0) * corr;
    }
}

