/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.ServiceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SavedAwareRatingPlan
extends RatingPlan {
    private List<RatingPeriod> m_savedRatingPeriods = new ArrayList<RatingPeriod>();

    public SavedAwareRatingPlan(ServiceProvider provider, String name, String anIdentity, String serviceId) {
        super(provider, name, anIdentity, serviceId);
    }

    public SavedAwareRatingPlan(ServiceProvider provider, String anIdentity, String name) {
        super(provider, anIdentity, name);
    }

    public List<RatingPeriod> getActiveRatingPeriods() {
        return this.getAllRatingPeriods();
    }

    public List<RatingPeriod> getSavedRatingPeriods() {
        return Collections.unmodifiableList(this.m_savedRatingPeriods);
    }

    public void addSavedRatingPeriod(RatingPeriod period) {
        this.m_savedRatingPeriods.add(period);
    }

    public void removeSavedRatingPeriods() {
        List<RatingPeriod> activePeriods = this.getActiveRatingPeriods();
        for (RatingPeriod period : this.m_savedRatingPeriods) {
            activePeriods.remove(period);
        }
        this.m_savedRatingPeriods.clear();
    }

    public boolean containsSavedRatingPeriods() {
        return !this.m_savedRatingPeriods.isEmpty();
    }

    public boolean containsActiveRatingPeriods() {
        return this.containsRatingPeriods();
    }
}

