/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.exception.ServiceException;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.PluginName;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.ServiceUpgradeException;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Service
implements Cloneable {
    private String TAG_NAME = "Service";
    @Deprecated
    public String status = "OFF";
    @Deprecated
    public Map<Object, Object> myOwners = new HashMap<Object, Object>();
    private String myServiceId;
    private String myRevision;
    private Calendar myLastModified;
    private String myDefinitionFileName;
    private String myConditionsFileName;
    private String myActiveDefinitionFileName;
    private String myActiveConditionsFileName;
    private ClassRepository myClassRepository;
    private boolean myIsStarted = false;
    private boolean myLastUpdateOk = false;
    private DataSetFactory myDataSetFactory = null;
    private static final String NODE_TS_DEFAULT = "\n\t<TariffStructures>\n\t\t<TariffStructure name=\"TariffStructure\" class=\"ericsson.ere.RatingStructure\" profile=\"ericsson.ere.RatingStructureProfile\" />\n\t</TariffStructures>\n\t<Nodes>\n\t\t<Node name=\"Defs\" class=\"ericsson.ere.statement.DefsStatement\" profile=\"ericsson.ere.statement.DefsStatementProfile\" />\n\t\t<Node name=\"Node\" class=\"ericsson.ere.statement.NodeStatement\" profile=\"ericsson.ere.statement.NodeStatementProfile\" />\n\t</Nodes>\n";

    @Deprecated
    public Service(String serviceId, String definitionFileName, String conditionsFileName, String revision, Calendar lastModified, InputStream data) {
        this(serviceId, definitionFileName, conditionsFileName, revision, lastModified);
    }

    public Service(String serviceId, String definitionFileName, String conditionsFileName, String revision, Calendar lastModified) {
        this.myServiceId = serviceId.trim();
        this.myRevision = revision;
        this.myDefinitionFileName = StringUtil.convertFilePathString(definitionFileName);
        this.myConditionsFileName = StringUtil.convertFilePathString(conditionsFileName);
        this.myLastModified = lastModified;
        this.myClassRepository = this.createClassRepository();
    }

    protected ClassRepository createClassRepository() {
        return new ClassRepository();
    }

    public Service(String serviceName) {
        this(serviceName, null, null, null, null);
    }

    public void changeServiceName(String newName, EreManager ereManager) throws Exception {
        if (ereManager.containsServiceCaseInsensitive(newName.trim()) && !newName.equalsIgnoreCase(this.myServiceId)) {
            throw new Exception(EreDefs.getErrorString("error.serviceAlreadyExists") + newName + " (no case sensitivity)");
        }
        ereManager.removeService(this.myServiceId);
        this.myServiceId = newName.trim();
        ereManager.addService(this);
    }

    public void startService(Element definition, Element conditions) throws Exception {
        if (conditions != null) {
            this.myClassRepository.init(definition, conditions);
        } else {
            this.myClassRepository.init(definition);
        }
        this.myDataSetFactory = this.myClassRepository.getDataSetFactory();
        this.myDataSetFactory.init(this);
        this.myActiveDefinitionFileName = this.myDefinitionFileName;
        this.myActiveConditionsFileName = this.myConditionsFileName;
        this.status = "ON";
        this.myIsStarted = true;
        this.myLastUpdateOk = true;
    }

    public void setDataSetFactory(DataSetFactory factory) {
        this.myClassRepository.setDataSetFactory(factory);
        this.myDataSetFactory = factory;
        this.myDataSetFactory.init(this);
    }

    public void startService(InputStream definition, InputStream conditions) throws Exception {
        this.startService(XMLUtil.buildDocument(definition).getDocumentElement(), XMLUtil.buildDocument(conditions).getDocumentElement());
    }

    public void startService(Element definition) throws Exception {
        this.startService(definition, null);
    }

    public void startService(InputStream definition) throws Exception {
        this.startService(XMLUtil.buildDocument(definition).getDocumentElement(), null);
    }

    @Deprecated
    public void startService() throws Exception {
        Element defElem = XMLUtil.documentFromFile(this.myDefinitionFileName).getDocumentElement();
        Element condElem = null;
        if (this.isConditionStoredSeparate()) {
            condElem = this.checkDefaultUpdate(this.myConditionsFileName).getDocumentElement();
        }
        this.startService(defElem, condElem);
    }

    @Deprecated
    public void printToScreen() {
        System.out.println("Service Name : " + this.myServiceId);
    }

    @Deprecated
    public void update(String revision, String definitionFileName, InputStream definition, String conditionsFileName, InputStream conditions, Calendar lastModified) throws Exception {
        this.myLastUpdateOk = false;
        this.myLastModified = lastModified;
        this.myDefinitionFileName = StringUtil.convertFilePathString(definitionFileName);
        this.myConditionsFileName = StringUtil.convertFilePathString(conditionsFileName);
        this.myClassRepository.init(XMLUtil.buildDocument(definition).getDocumentElement(), XMLUtil.buildDocument(conditions).getDocumentElement());
        this.myDataSetFactory = this.myClassRepository.getDataSetFactory();
        this.myDataSetFactory.init(this);
        this.myActiveDefinitionFileName = this.myDefinitionFileName;
        this.myActiveConditionsFileName = this.myConditionsFileName;
        this.myRevision = revision;
        this.myLastUpdateOk = true;
        this.myIsStarted = true;
    }

    public void upgrade(Element root, boolean forced) throws ServiceUpgradeException {
        if (!forced) {
            this.compatibilityCheck(root);
        }
        try {
            this.myClassRepository.init(root);
            this.myDataSetFactory = this.myClassRepository.getDataSetFactory();
            this.myDataSetFactory.init(this);
        }
        catch (Exception e) {
            ServiceUpgradeException sue = new ServiceUpgradeException(e.getMessage());
            sue.setParsingFailed(true);
            throw sue;
        }
    }

    private void compatibilityCheck(Element root) throws ServiceUpgradeException {
        ClassRepository repository = new ClassRepository();
        try {
            repository.init(root);
        }
        catch (Exception e) {
            ServiceUpgradeException sue = new ServiceUpgradeException(e.getMessage());
            sue.setParsingFailed(true);
            throw sue;
        }
        this.checkBaseConditions(repository);
        this.checkDefinedConditions(repository);
        this.checkModifiers(repository);
        this.checkFields(repository);
    }

    private void checkBaseConditions(ClassRepository r) throws ServiceUpgradeException {
        List<PluginName> existingConditions = this.myClassRepository.getBaseConditionList();
        int len = existingConditions.size();
        for (int i = 0; i < len; ++i) {
            String name = existingConditions.get(i).getName();
            String oldClass = this.myClassRepository.getBaseConditionClass(name);
            String newClass = r.getBaseConditionClass(name);
            if (newClass == null) {
                if (!this.isBaseConditionUsed(name)) continue;
                ServiceUpgradeException sue = new ServiceUpgradeException("The used base condition '" + name + "' has been removed from the new service.");
                sue.setUsedConditionRemoved(true);
                sue.setForcable(true);
                throw sue;
            }
            if (oldClass.equals(newClass) || !this.isBaseConditionUsed(name)) continue;
            ServiceUpgradeException sue = new ServiceUpgradeException("The base condition '" + name + "' has changed implementation in the new service.");
            sue.setConditionClassChanged(true);
            sue.setForcable(true);
            throw sue;
        }
    }

    private void checkDefinedConditions(ClassRepository r) throws ServiceUpgradeException {
        List<PluginName> existingConditions = this.myClassRepository.getDefinedConditionList();
        int len = existingConditions.size();
        for (int i = 0; i < len; ++i) {
            String name = existingConditions.get(i).getName();
            String oldClass = this.myClassRepository.getConditionClassName(name);
            String newClass = r.getConditionClassName(name);
            if (newClass == null) {
                if (!this.isConditionUsed(name)) continue;
                if (this.isBasedOnBaseCondition(oldClass)) {
                    ServiceUpgradeException sue = new ServiceUpgradeException("The used field condition '" + name + "' has been removed from the new service.");
                    sue.setUsedFieldConditionRemoved(true);
                    sue.setForcable(true);
                    throw sue;
                }
                ServiceUpgradeException sue = new ServiceUpgradeException("The used generic condition '" + name + "' has been removed from the new service.");
                sue.setUsedConditionRemoved(true);
                sue.setForcable(true);
                throw sue;
            }
            if (oldClass.equals(newClass) || !this.isConditionUsed(name)) continue;
            ServiceUpgradeException sue = new ServiceUpgradeException("The generic condition '" + name + "' has changed implementation in the new service.");
            sue.setConditionClassChanged(true);
            sue.setForcable(true);
            throw sue;
        }
    }

    private void checkModifiers(ClassRepository r) throws ServiceUpgradeException {
        List<PluginName> existingModifiers = this.myClassRepository.getModifierList();
        int len = existingModifiers.size();
        for (int i = 0; i < len; ++i) {
            String name = existingModifiers.get(i).getName();
            String oldClass = this.myClassRepository.getModifierClassName(name);
            String newClass = r.getModifierClassName(name);
            if (newClass == null) {
                if (!this.isModifierUsed(name)) continue;
                ServiceUpgradeException sue = new ServiceUpgradeException("The used modifier '" + name + "' has been removed from the new service.");
                sue.setUsedModifierRemoved(true);
                sue.setForcable(true);
                throw sue;
            }
            if (oldClass.equals(newClass) || !this.isModifierUsed(name)) continue;
            ServiceUpgradeException sue = new ServiceUpgradeException("The modifier '" + name + "' has changed implementation in the new service.");
            sue.setModifierClassChanged(true);
            sue.setForcable(true);
            throw sue;
        }
    }

    private void checkFields(ClassRepository repository) throws ServiceUpgradeException {
        List<FieldHierarchyNode> allFields = this.myClassRepository.getFieldRepository().getAllFields();
        for (FieldHierarchyNode field : allFields) {
            boolean fieldIsTDF = field.isLeaf() && "INTERNAL".equals(((FieldDefinition)field).getParameterType());
            if (fieldIsTDF) continue;
            String fieldName = field.getCanonicalName();
            FieldHierarchyNode newField = repository.getFieldRepository().getFieldByName(fieldName);
            if (newField == null) {
                ServiceUpgradeException sue = new ServiceUpgradeException("The field '" + fieldName + "' has been removed from the new service.");
                sue.setUsedFieldRemoved(true);
                sue.setForcable(true);
                throw sue;
            }
            if (field.equals(newField)) continue;
            ServiceUpgradeException sue = new ServiceUpgradeException("The field '" + fieldName + "' has been changed in the new service.");
            sue.setFieldChanged(true);
            sue.setForcable(true);
            throw sue;
        }
    }

    private boolean isBasedOnBaseCondition(String className) {
        return this.myClassRepository.getBaseConditionClasses().containsValue(className);
    }

    private boolean isBaseConditionUsed(String name) {
        if (this.myClassRepository.getConnectedBaseConditions().containsValue(name)) {
            return this.isConditionUsed(name);
        }
        return false;
    }

    private boolean isConditionUsed(String name) {
        return true;
    }

    private boolean isModifierUsed(String name) {
        return true;
    }

    public RatingData getRatingData() {
        return this.getRatingData(false);
    }

    public RatingData getRatingData(boolean setDefaultValues) {
        RatingData ratingData = new RatingData(this);
        List<FieldDefinition> dataDescription = this.myClassRepository.getFieldDefinitions();
        int len = dataDescription.size();
        for (int i = 0; i < len; ++i) {
            FieldDefinition def = dataDescription.get(i);
            RatingDataField ratingDataField = def.getRatingDataField();
            if (setDefaultValues && def.hasDefaultValue()) {
                ratingDataField.setDefault(def.getDefaultValue(), def.getSupportArray());
            }
            ratingData.put(ratingDataField.getName(), ratingDataField);
            if (!ratingDataField.hasTagNumber()) continue;
            ratingData.myTagNumberLookup.put(new Integer(ratingDataField.getTagNumber()), ratingDataField);
            ratingData.mySupportTagNumbers = true;
        }
        List<FieldDefinition> workingParams = this.myClassRepository.getWorkingParameterFields();
        int len2 = workingParams.size();
        for (int i = 0; i < len2; ++i) {
            FieldDefinition def = workingParams.get(i);
            RatingDataField field = def.getRatingDataField();
            if (def.hasDefaultValue()) {
                field.setDefault(def.getDefaultValue(), def.getSupportArray());
            }
            ratingData.putWorkingParameter(field.getName(), field);
        }
        return ratingData;
    }

    public boolean isStarted() {
        return this.myIsStarted;
    }

    public boolean lastUpdateOk() {
        return this.myLastUpdateOk;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public String getId() {
        return this.myServiceId;
    }

    @Deprecated
    public String getFileName() {
        return this.getDefinitionFileName();
    }

    @Deprecated
    public void setFileName(String fileName) {
        this.setDefinitionFileName(fileName);
    }

    public String getActiveDefinitionFileName() {
        return this.myActiveDefinitionFileName;
    }

    public String getActiveConditionsFileName() {
        return this.myActiveConditionsFileName;
    }

    public String getDefinitionFileName() {
        return this.myDefinitionFileName;
    }

    public void setDefinitionFileName(String fileName) {
        this.myDefinitionFileName = StringUtil.convertFilePathString(fileName);
    }

    public String getConditionsFileName() {
        return this.myConditionsFileName;
    }

    public void setConditionsFileName(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            this.myConditionsFileName = "";
            return;
        }
        this.myConditionsFileName = StringUtil.convertFilePathString(fileName);
    }

    public ClassRepository getClassRepository() {
        return this.myClassRepository;
    }

    public ClassRepository getClassRepository(FieldContext context) {
        return this.myClassRepository.getClassRepositoryWithContext(context);
    }

    public void setClassRepository(ClassRepository aRepository) {
        this.myClassRepository = aRepository;
    }

    public Calendar getLastModified() {
        return this.myLastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.myLastModified = lastModified;
    }

    public boolean equals(Object anObject) {
        Service service = (Service)anObject;
        return service.getId().equals(this.myServiceId.trim());
    }

    public Object clone() {
        Service service = new Service(this.myServiceId, this.myDefinitionFileName, this.myConditionsFileName, this.myRevision, this.myLastModified);
        return service;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n").append("ServiceId: ").append(this.myServiceId).append("\n");
        buffer.append("Definition File Name: ").append(this.myDefinitionFileName).append("\n");
        buffer.append("Conditions File Name: ").append(this.myConditionsFileName).append("\n");
        return buffer.toString();
    }

    public String getXMLDefinition(String aTabs) {
        String tabs = aTabs + "\t";
        StringBuffer buf = new StringBuffer();
        buf.append(this.getStartTag(tabs) + "\n");
        buf.append(this.getEndTag(tabs) + "\n");
        return buf.toString();
    }

    public String getStartTag(String tabs) {
        return tabs + "<" + this.TAG_NAME + this.createAttribute("Name", this.myServiceId) + this.createAttribute("DefinitionFile", this.myDefinitionFileName) + this.createAttribute("ConditionLeafClassFile", this.myConditionsFileName) + " >";
    }

    public String getEndTag(String tabs) {
        return tabs + "</" + this.TAG_NAME + ">";
    }

    private String createAttribute(String name, String value) {
        return " " + name + "=" + '\"' + value + '\"' + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document checkDefaultUpdate(String structureFile) throws Exception {
        Document doc = XMLUtil.documentFromFile(structureFile);
        if (!doc.getDocumentElement().getNodeName().equals("Settings")) {
            throw new Exception("Service: Invalid root tag for Service Condition. Must be 'Settings' but was '" + doc.getDocumentElement().getNodeName() + "'.");
        }
        NodeList tariffs = doc.getElementsByTagName("TariffStructures");
        if (tariffs.getLength() > 0) {
            return doc;
        }
        File f = new File(structureFile);
        StringWriter outBuf = new StringWriter();
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String line1 = in.readLine();
            while (line1.indexOf("<Settings>") < 0) {
                outBuf.write(line1);
                outBuf.write(10);
                line1 = in.readLine();
            }
            outBuf.write(line1);
            outBuf.write(10);
            outBuf.write(NODE_TS_DEFAULT);
            while (in.ready()) {
                outBuf.write(in.readLine());
                outBuf.write(10);
            }
        }
        if (f.canWrite()) {
            FileHandling.writeToFile(outBuf.toString(), f);
        } else {
            System.err.println("No permission writing to file: " + structureFile + " Using defaults anyway.");
        }
        return XMLUtil.buildDocumentFromString(outBuf.toString());
    }

    public boolean isConditionStoredSeparate() {
        return this.myConditionsFileName != null && this.myConditionsFileName.trim().length() > 0 && new File(this.myConditionsFileName).isFile();
    }

    public DataSet getDataSet() {
        return this.myDataSetFactory.createDataSet();
    }

    public Object getSimulationFactory() {
        return this.myClassRepository.getSimulationFactory();
    }

    public MultiDataUpdateFilterFactory getMultiDataUpdateFilterFactory() throws ServiceException {
        return this.myClassRepository.getMDUFilterFactory();
    }

    public void setJumperSupport(JumperSupport jumper) {
        this.myClassRepository.setJumperSupport(jumper);
    }
}

