/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.progress;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public final class SynchronizedEDTProgressVisualizer
implements ProgressVisualizer {
    private ProgressVisualizer myVisualizer;

    public SynchronizedEDTProgressVisualizer(ProgressVisualizer visualizer) {
        this.myVisualizer = visualizer;
    }

    public static ProgressIndicator createThreadSafeProgressIndicator(ProgressVisualizer visualizer) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(new SynchronizedEDTProgressVisualizer(visualizer));
        return handler.getProgressIndicator();
    }

    public static ProgressIndicator createThreadSafeProgressIndicator(ProgressVisualizer visualizer, int goal) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(goal, new SynchronizedEDTProgressVisualizer(visualizer));
        return handler.getProgressIndicator();
    }

    @Override
    public boolean isCanceled() {
        return this.myVisualizer.isCanceled();
    }

    @Override
    public void setConfirmBeforeExit() {
        this.myVisualizer.setConfirmBeforeExit();
    }

    @Override
    public void setInfoText(final String text) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SynchronizedEDTProgressVisualizer.this.myVisualizer.setInfoText(text);
            }
        });
    }

    @Override
    public void setProgressGoal(final int goal) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SynchronizedEDTProgressVisualizer.this.myVisualizer.setProgressGoal(goal);
            }
        });
    }

    @Override
    public void setValue(final int value) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SynchronizedEDTProgressVisualizer.this.myVisualizer.setValue(value);
            }
        });
    }

    @Override
    public void showAdditionalInfo(final String text) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SynchronizedEDTProgressVisualizer.this.myVisualizer.showAdditionalInfo(text);
            }
        });
    }

    private void invokeAndWait(Runnable r) {
        try {
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }
}

