/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.ratingrules;

import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.ratingrules.FatalParsingError;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;

public class RatingBuilderErrorHandler
implements RatingRuleBuilderErrorHandler {
    private Set<Throwable> myHandledErrors = new HashSet<Throwable>();

    @Override
    public void handleError(Throwable theError, Node theXMLcontext, String theMethod, String details) {
        Throwable realError = this.findRealError(theError);
        if (this.myHandledErrors.contains(realError) && realError instanceof RuntimeException) {
            throw (RuntimeException)realError;
        }
        this.myHandledErrors.add(realError);
        String realDetails = "";
        if (!details.equals(theError.toString())) {
            realDetails = " (" + details + ")";
        }
        realDetails = String.format("Fatal parsing error%s!", realDetails);
        throw new FatalParsingError(realDetails, realError, theXMLcontext);
    }

    private Throwable findRealError(Throwable error) {
        Throwable t = error;
        while (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        return t;
    }
}

