/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.statement;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.Modifier;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.LeafStatement;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNodeStatement
extends Statement {
    protected List<DAGNode> myConditions = null;
    protected List<DAGNode> myChildren = null;

    public AbstractNodeStatement(String name) {
        super(name);
    }

    public AbstractNodeStatement() {
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        int nCond = 0;
        int nNode = 0;
        NodeList children = iterator.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if ("Node".equalsIgnoreCase(node.getNodeName())) {
                ++nNode;
            }
            if (!"Condition".equalsIgnoreCase(node.getNodeName())) continue;
            ++nCond;
        }
        this.myConditions = nCond > 0 ? new ArrayList<DAGNode>(nCond) : null;
        this.myChildren = nNode > 0 ? new ArrayList<DAGNode>(nNode) : null;
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myChildren == null ? 0 : this.myChildren.hashCode());
        result = 31 * result + (this.myConditions == null ? 0 : this.myConditions.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeStatement other = (AbstractNodeStatement)obj;
        if (this.myChildren == null ? other.myChildren != null : !this.myChildren.equals(other.myChildren)) {
            return false;
        }
        return !(this.myConditions == null ? other.myConditions != null : !this.myConditions.equals(other.myConditions));
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        int nCond = 0;
        if (this.myConditions != null && index < (nCond = this.myConditions.size())) {
            return this.myConditions.get(index);
        }
        DAGNode node = this.myChildren.get(index - nCond);
        if (node instanceof LeafStatement) {
            node = node.getChildAt(0);
        }
        return node;
    }

    @Override
    public int getChildCount() {
        int nCond = this.myConditions == null ? 0 : this.myConditions.size();
        int nChild = this.myChildren == null ? 0 : this.myChildren.size();
        return nCond + nChild;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doInsert(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        int ncond;
        if (DAGUtil.pathExists(node, this)) {
            throw new IllegalArgumentException("Cycle detected when trying to add node: " + node + " to " + this);
        }
        if (index > this.getChildCount()) throw new IndexOutOfBoundsException("Index out of bounds: " + index + " Number of children: " + this.getChildCount());
        int n = ncond = this.myConditions == null ? 0 : this.myConditions.size();
        if (node instanceof Condition) {
            if (this.myConditions == null) {
                this.myConditions = new ArrayList<DAGNode>();
            }
            if (index > this.myConditions.size()) {
                this.myConditions.add(node);
                return;
            } else {
                this.myConditions.add(index, node);
            }
            return;
        } else if (node instanceof Modifier) {
            if (this.myChildren == null) {
                this.myChildren = new ArrayList<DAGNode>();
            }
            int i = index - ncond;
            LeafStatement leaf = new LeafStatement(this.getName());
            leaf.setModifier((Modifier)((Object)node));
            if (i > this.myChildren.size()) {
                this.myChildren.add(leaf);
                return;
            } else {
                this.myChildren.add(i, leaf);
            }
            return;
        } else {
            int i;
            if (!(node instanceof Statement)) throw new IllegalArgumentException("Unrecognized node class: " + node.getClass());
            if (this.myChildren == null) {
                this.myChildren = new ArrayList<DAGNode>();
            }
            if ((i = index - ncond) > this.myChildren.size()) {
                this.myChildren.add(node);
                return;
            } else {
                this.myChildren.add(i, node);
            }
        }
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myConditions != null) {
            i = DAGUtil.indexOf(child, this.myConditions);
        }
        if (i >= 0) {
            this.myConditions.set(i, replacement);
        } else {
            if (this.myChildren != null) {
                i = DAGUtil.indexOf(child, this.myChildren);
            }
            if (i >= 0) {
                this.myChildren.set(i, replacement);
            } else {
                for (DAGNode n : this.myChildren) {
                    LeafStatement stmt;
                    if (!(n instanceof LeafStatement) || (stmt = (LeafStatement)n).getModifier() != child) continue;
                    stmt.replace(child, replacement);
                }
            }
        }
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void add(XMLInitializable node) throws IllegalArgumentException {
        if (node instanceof Condition) {
            this.addCondition((Condition)node);
        } else if (node instanceof Modifier) {
            this.addModifier((Modifier)node);
        } else if (node instanceof Statement) {
            this.addChildStatement((Statement)node);
        } else {
            throw new IllegalArgumentException("Unrecognized node class: " + node.getClass());
        }
    }

    public void addCondition(Condition aCondition) {
        if (this.myConditions == null) {
            this.myConditions = new ArrayList<DAGNode>();
        }
        this.insertChildAt(this.myConditions.size(), (DAGNode)((Object)aCondition));
    }

    public void addModifier(Modifier aModifier) throws IllegalArgumentException {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<DAGNode>(1);
        }
        if (!this.myChildren.isEmpty()) {
            throw new IllegalArgumentException("Modifier not allowed for node: " + this.getName() + ", no of subnodes: " + this.myChildren.size());
        }
        this.insertChildAt(this.getChildCount(), (DAGNode)((Object)aModifier));
    }

    public void addCondition(Condition[] conditions) throws Exception {
        if (conditions.length == 0) {
            throw new Exception("TariffAbstractNodeStatement.addCondition(). Array contains no elements");
        }
        if (this.myConditions == null) {
            this.myConditions = new ArrayList<DAGNode>(conditions.length);
        }
        for (int ii = 0; ii < conditions.length; ++ii) {
            if (conditions[ii] == null) continue;
            this.insertChildAt(this.myConditions.size(), (DAGNode)((Object)conditions[ii]));
        }
    }

    public void addChildStatement(Statement aChildStatement) throws IllegalArgumentException {
        DAGNode firstChild;
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<DAGNode>();
        }
        if (!this.myChildren.isEmpty() && (firstChild = this.myChildren.get(0)) instanceof LeafStatement) {
            Modifier m = ((LeafStatement)firstChild).getModifier();
            throw new IllegalArgumentException("SubNodes not allowed for node: " + this.getName() + ", has modifier: " + m.getClass());
        }
        this.insertChildAt(this.getChildCount(), aChildStatement);
    }

    @Override
    public abstract void rate(RatingData var1, DoubleValue var2, LongValue var3) throws Exception;
}

