/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.statement;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.Modifier;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.statements.DefsStatement.class)
public class DefsStatement
extends Statement
implements XMLInitializable {
    private List<DAGNode> myConditions = null;
    private List<DAGNode> myNodes = null;
    private List<DAGNode> myModifiers = null;

    public DefsStatement() {
    }

    public DefsStatement(String name) {
        super(name);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        int nCond = 0;
        int nNode = 0;
        int nMod = 0;
        NodeList children = iterator.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if ("Node".equalsIgnoreCase(node.getNodeName())) {
                ++nNode;
            }
            if ("Condition".equalsIgnoreCase(node.getNodeName())) {
                ++nCond;
            }
            if ("Tariff".equalsIgnoreCase(node.getNodeName())) {
                ++nMod;
            }
            if ("Modifier".equalsIgnoreCase(node.getNodeName())) {
                ++nMod;
            }
            if (!"Action".equalsIgnoreCase(node.getNodeName())) continue;
            ++nMod;
        }
        this.myConditions = nCond > 0 ? new ArrayList<DAGNode>(nCond) : null;
        this.myNodes = nNode > 0 ? new ArrayList<DAGNode>(nNode) : null;
        this.myModifiers = nMod > 0 ? new ArrayList<DAGNode>(nMod) : null;
        return this;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        int nMod;
        int nNodes;
        int nCond;
        int i = index;
        int n = nCond = this.myConditions == null ? 0 : this.myConditions.size();
        if (i < nCond) {
            return this.myConditions.get(i);
        }
        int n2 = nNodes = this.myNodes == null ? 0 : this.myNodes.size();
        if ((i -= nCond) < nNodes) {
            return this.myNodes.get(i);
        }
        int n3 = nMod = this.myModifiers == null ? 0 : this.myModifiers.size();
        if ((i -= nNodes) < nMod) {
            return this.myModifiers.get(i);
        }
        throw new IndexOutOfBoundsException("Illegal index: " + index + ". Number of children: " + this.getChildCount());
    }

    @Override
    public int getChildCount() {
        int sum = this.myConditions == null ? 0 : this.myConditions.size();
        sum += this.myNodes == null ? 0 : this.myNodes.size();
        return sum += this.myModifiers == null ? 0 : this.myModifiers.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doInsert(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (DAGUtil.pathExists(node, this)) {
            throw new IllegalArgumentException("Cycle detected when trying to add node: " + node + " to " + this);
        }
        if (index > this.getChildCount()) throw new IndexOutOfBoundsException("Index out of bounds: " + index + " Number of children: " + this.getChildCount());
        if (node instanceof Condition) {
            if (this.myConditions == null) {
                this.myConditions = new ArrayList<DAGNode>();
            }
            if (index > this.myConditions.size()) {
                this.myConditions.add(node);
                return;
            } else {
                this.myConditions.add(index, node);
            }
            return;
        } else if (node instanceof Modifier) {
            if (this.myModifiers == null) {
                this.myModifiers = new ArrayList<DAGNode>();
            }
            if (index > this.myModifiers.size()) {
                this.myModifiers.add(node);
                return;
            } else {
                this.myModifiers.add(index, node);
            }
            return;
        } else {
            if (!(node instanceof Statement)) throw new IllegalArgumentException("Unrecognized node class: " + node.getClass());
            if (this.myNodes == null) {
                this.myNodes = new ArrayList<DAGNode>();
            }
            if (index > this.myNodes.size()) {
                this.myNodes.add(node);
                return;
            } else {
                this.myNodes.add(index, node);
            }
        }
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myConditions != null) {
            i = DAGUtil.indexOf(child, this.myConditions);
        }
        if (i >= 0) {
            this.myConditions.set(i, replacement);
        } else {
            if (this.myNodes != null) {
                i = DAGUtil.indexOf(child, this.myNodes);
            }
            if (i >= 0) {
                this.myNodes.set(i, replacement);
            } else {
                if (this.myModifiers != null) {
                    i = DAGUtil.indexOf(child, this.myModifiers);
                }
                if (i >= 0) {
                    this.myModifiers.set(i, replacement);
                } else {
                    throw new IllegalArgumentException("Child not found: " + child);
                }
            }
        }
    }

    @Override
    public void add(XMLInitializable node) throws IllegalArgumentException {
        this.insertChildAt(this.getChildCount(), (DAGNode)((Object)node));
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void rate(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myConditions == null ? 0 : this.myConditions.hashCode());
        result = 31 * result + (this.myModifiers == null ? 0 : this.myModifiers.hashCode());
        result = 31 * result + (this.myNodes == null ? 0 : this.myNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefsStatement other = (DefsStatement)obj;
        if (this.myConditions == null ? other.myConditions != null : !this.myConditions.equals(other.myConditions)) {
            return false;
        }
        if (this.myModifiers == null ? other.myModifiers != null : !this.myModifiers.equals(other.myModifiers)) {
            return false;
        }
        return !(this.myNodes == null ? other.myNodes != null : !this.myNodes.equals(other.myNodes));
    }
}

