/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.util;

import ericsson.ere.defs.EreClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtil {
    private static List<String> myClasses = null;
    private static final String[] excludePackage = new String[]{"javax", "sun", "java", "org", "gui", "util"};

    public static void reset() {
        myClasses = null;
    }

    public static List<String> getAllClasses() {
        PackageUtil.loadClassesFromClassPath();
        return myClasses;
    }

    public static List<String> getClassesImplementing(String interfacePath) {
        ArrayList<String> interfaceList = new ArrayList<String>();
        PackageUtil.loadClassesFromClassPath();
        block2: for (String currentClass : myClasses) {
            try {
                Class<?>[] interfaces = EreClassLoader.getClass(currentClass).getInterfaces();
                for (int ii = 0; ii < interfaces.length; ++ii) {
                    if (!interfaces[ii].getName().equals(interfacePath)) continue;
                    interfaceList.add(currentClass);
                    continue block2;
                }
            }
            catch (Throwable throwable) {
            }
        }
        return interfaceList;
    }

    public static List<String> getClassesExtending(String extendedClass) {
        ArrayList<String> extendList = new ArrayList<String>();
        PackageUtil.loadClassesFromClassPath();
        Iterator<String> iterator = myClasses.iterator();
        while (iterator.hasNext()) {
            try {
                String currentClass = iterator.next();
                Class<?> subclass = EreClassLoader.getClass(currentClass);
                if (Modifier.isAbstract(subclass.getModifiers())) continue;
                for (Class<?> superclass = subclass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                    String className = superclass.getName();
                    if (!className.equals(extendedClass)) continue;
                    extendList.add(currentClass);
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
            }
        }
        return extendList;
    }

    private static void loadClassesFromClassPath() {
        if (myClasses != null) {
            return;
        }
        myClasses = new ArrayList<String>();
        List<URL> list = EreClassLoader.getAllUrls();
        list.addAll(PackageUtil.classPathToURLList());
        for (URL currentClassPathDir : PackageUtil.getUniqueList(list)) {
            String file = currentClassPathDir.getFile();
            try {
                file = URLDecoder.decode(file, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (currentClassPathDir.getFile().endsWith(".jar")) {
                PackageUtil.addToList(PackageUtil.getAllClassesFromJarFile(file), myClasses);
                continue;
            }
            PackageUtil.addToList(PackageUtil.getAllClassesFromPackageDir(file), myClasses);
        }
    }

    private static List<URL> getUniqueList(List<URL> list) {
        ArrayList<URL> retList = new ArrayList<URL>();
        for (int ii = 0; ii < list.size(); ++ii) {
            if (retList.contains(list.get(ii))) continue;
            retList.add(list.get(ii));
        }
        return retList;
    }

    private static List<URL> classPathToURLList() {
        ArrayList<URL> listToReturn = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            URL url = PackageUtil.pathToURL(tokenizer.nextToken());
            if (url == null || listToReturn.contains(url)) continue;
            listToReturn.add(url);
        }
        return listToReturn;
    }

    private static URL pathToURL(String path) {
        URL url = null;
        try {
            url = !path.startsWith("file:/") ? (path.startsWith("/") ? new URL("file:" + path) : new URL("file:/" + path)) : new URL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private static List<String> getAllClassesFromJarFile(String jarFileName) {
        LinkedList<String> jarClasses = new LinkedList<String>();
        try {
            JarFile aJarFile = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = aJarFile.entries();
            while (jarEntries.hasMoreElements()) {
                String currentClassname = jarEntries.nextElement().getName();
                int idxClass = currentClassname.indexOf(".class");
                if (idxClass == -1 || PackageUtil.isClassExcluded(currentClassname = currentClassname.substring(0, idxClass).replace('/', '.').replace('\\', '.'))) continue;
                jarClasses.add(currentClassname);
            }
        }
        catch (IOException e) {
            System.out.println("ERROR handling " + jarFileName + " due to " + e.getMessage());
        }
        return jarClasses;
    }

    private static List<String> getAllClassesFromPackageDir(String dirName) {
        return PackageUtil.getAllClassesFromPackageDir(dirName, null);
    }

    private static List<String> getAllClassesFromPackageDir(String dirName, String parentPackage) {
        ArrayList<String> classes = new ArrayList<String>();
        String packageName = "";
        File directory = new File(dirName);
        packageName = parentPackage == null ? "" : (parentPackage.length() == 0 ? directory.getName() : parentPackage + "." + directory.getName());
        if (PackageUtil.isPackageExcluded(packageName)) {
            return null;
        }
        String[] classFiles = directory.list();
        if (classFiles == null) {
            return null;
        }
        for (int ii = 0; ii < classFiles.length; ++ii) {
            if (new File(dirName + File.separatorChar + classFiles[ii]).isDirectory()) {
                PackageUtil.addToList(PackageUtil.getAllClassesFromPackageDir(dirName + File.separatorChar + classFiles[ii], packageName), classes);
            }
            if (!classFiles[ii].endsWith(".class")) continue;
            String classname = packageName + "." + classFiles[ii].substring(0, classFiles[ii].indexOf(46));
            classes.add(classname);
        }
        return classes;
    }

    private static void addToList(List<String> fromList, List<String> toList) {
        if (fromList == null) {
            return;
        }
        Iterator<String> iterator = fromList.iterator();
        while (iterator.hasNext()) {
            toList.add(iterator.next());
        }
    }

    private static boolean isPackageExcluded(String packageName) {
        for (int ii = 0; ii < excludePackage.length; ++ii) {
            if (!packageName.equals(excludePackage[ii])) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassExcluded(String className) {
        for (int ii = 0; ii < excludePackage.length; ++ii) {
            if (!className.startsWith(excludePackage[ii])) continue;
            return true;
        }
        return false;
    }
}

