/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Uploader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String urlString, String ref, String fname, String provider, String uname, String psw) throws IOException {
        File file = new File(fname);
        byte[] fileBuffer = new byte[(int)file.length()];
        try (BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(file));){
            fileIn.read(fileBuffer);
        }
        return Uploader.uploadFile(fileBuffer, urlString, ref, file.getName(), provider, uname, psw);
    }

    public static String uploadFile(byte[] fileBuffer, String urlString, String ref, String name, String provider, String uname, String psw) throws IOException {
        String s;
        Deflater deflater = new Deflater(9);
        byte[] defBuffer = new byte[fileBuffer.length + 10];
        deflater.setInput(fileBuffer);
        deflater.finish();
        int size = deflater.deflate(defBuffer);
        CRC32 checksum = new CRC32();
        checksum.update(defBuffer, 0, size);
        long crc32 = checksum.getValue();
        urlString = urlString + "?action=upload&uname=" + uname + "&psw=" + psw + "&reference=" + ref + "&provider=" + provider + "&fname=" + name + "&crc32=" + crc32;
        URL url = new URL(urlString);
        HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
        urlc.setDoOutput(true);
        urlc.setDoInput(true);
        urlc.setUseCaches(false);
        urlc.setRequestMethod("POST");
        urlc.setRequestProperty("Content-Length", "" + size);
        urlc.setRequestProperty("Content-Type", "ere");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(urlc.getOutputStream()));
        out.write(defBuffer, 0, size);
        out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuffer a = new StringBuffer();
        for (int i = 0; i < 30 && (s = in.readLine()) != null; ++i) {
            a.append(s + "\n");
        }
        return a.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFile(String destFile, String urlString, String ref, String fname, String uname, String psw) throws IOException {
        StringBuffer result = new StringBuffer();
        byte[] data = Uploader.downloadFile(result, urlString, ref, fname, uname, psw);
        if (data == null) {
            return result.toString();
        }
        try {
            File file = new File(destFile);
            try (FileOutputStream fileos = new FileOutputStream(file);){
                fileos.write(data);
            }
        }
        catch (Exception e) {
            return "Failed. Could not open file.";
        }
        return "File downloaded. " + fname;
    }

    public static byte[] downloadFile(StringBuffer result, String urlString, String ref, String fname, String uname, String psw) throws IOException {
        urlString = urlString + "?action=download&uname=" + uname + "&psw=" + psw + "&reference=" + ref + "&fname=" + fname;
        URL url = new URL(urlString);
        HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
        urlc.setDoOutput(true);
        urlc.setDoInput(true);
        urlc.setUseCaches(false);
        urlc.setRequestMethod("POST");
        urlc.setRequestProperty("Content-Type", "ere");
        InputStream is = urlc.getInputStream();
        String inline = Uploader.readLine(is);
        if (inline.length() != 0) {
            result.append(inline);
            return null;
        }
        inline = Uploader.readLine(is);
        if (!inline.startsWith("Content-Length: ")) {
            result.append("Failed. Unknown data received.");
            return null;
        }
        int contentLength = Uploader.toInt(inline.substring(16));
        if (contentLength <= 0) {
            result.append("Failed. Content length was not correctly received");
            return null;
        }
        inline = Uploader.readLine(is);
        if (!inline.startsWith("CRC32: ")) {
            result.append("Failed. Unknown data received.");
            return null;
        }
        long recCrc32 = 0L;
        try {
            recCrc32 = Long.parseLong(inline.substring(7));
        }
        catch (Exception e) {
            result.append("Failed. CRC was not correctly received");
            return null;
        }
        inline = Uploader.readLine(is);
        if (inline.length() != 0) {
            result.append("Failed. Unknown data received.");
            return null;
        }
        byte[] buffer = null;
        try {
            buffer = new byte[contentLength];
            int remaining = contentLength;
            int soFar = 0;
            while (remaining > 0) {
                int read = is.read(buffer, soFar, remaining);
                remaining -= read;
                soFar += read;
            }
        }
        catch (Exception e) {
            result.append("Failed. Could not receive complete file");
            return null;
        }
        CRC32 checksum = new CRC32();
        checksum.update(buffer);
        long crc32 = checksum.getValue();
        if (recCrc32 != crc32) {
            result.append("Failed. Checksum missmatch. Calculated: " + crc32 + ". Received: " + recCrc32);
            return null;
        }
        byte[] decompressed = new byte[Uploader.getSizeOfDecompressedData(buffer)];
        Inflater inflater = new Inflater();
        inflater.setInput(buffer);
        int size = 0;
        int offset = 0;
        while (!inflater.finished()) {
            try {
                size = inflater.inflate(decompressed, offset, decompressed.length - offset);
                offset += size;
            }
            catch (Exception dfe) {
                result.append("Failed. Exception when decompressing data");
                return null;
            }
        }
        result.append("File downloaded. " + fname);
        return decompressed;
    }

    private static String readLine(InputStream is) throws IOException {
        int c;
        StringBuffer line = new StringBuffer();
        while ((c = is.read()) != -1) {
            if (c == 10) {
                return line.toString();
            }
            if (c == 13) continue;
            line.append((char)c);
        }
        return line.toString();
    }

    private static int toInt(String value) throws NumberFormatException {
        return Integer.parseInt(value);
    }

    private static int getSizeOfDecompressedData(byte[] compressed) {
        byte[] tmp = new byte[10000];
        Inflater inflater = new Inflater();
        inflater.setInput(compressed);
        int size = 0;
        while (!inflater.finished()) {
            try {
                size += inflater.inflate(tmp);
            }
            catch (Exception exception) {}
        }
        return size;
    }
}

