/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import java.math.BigInteger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AllIntegersDocument
extends PlainDocument
implements FieldValidation {
    public static final BigInteger MAX_ULONG = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger BIGINT_ZERO = BigInteger.ZERO;
    private BigInteger myMin = MIN_LONG;
    private BigInteger myMax = MAX_ULONG;
    private boolean allowEmpty = false;
    private boolean isEnabled = true;
    private StatusInterface myStatusHandler = new RMAStatusInterface();

    public AllIntegersDocument() {
    }

    public AllIntegersDocument(BigInteger min, BigInteger max) {
        this.myMin = min;
        this.myMax = max;
    }

    public AllIntegersDocument(BigInteger min, BigInteger max, boolean empty) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = empty;
    }

    public BigInteger getMinValue() {
        return this.myMin;
    }

    public void setMinValue(BigInteger v) {
        this.myMin = v;
    }

    public BigInteger getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(BigInteger v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        this.myStatusHandler.printMessage("");
        String numbersOnlyString = "";
        int start = 0;
        if (AllIntegersDocument.isNegative(this.myMin) && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        if (str != null && str.length() > 0) {
            char[] chars = str.toCharArray();
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("Only digits '0-9' allowed");
            }
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0 && this.allowEmpty) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        if (proposedResult.length() == 0) {
            this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        try {
            BigInteger theValue = new BigInteger(proposedResult);
            if (AllIntegersDocument.isNegative(this.myMin) && AllIntegersDocument.isNegative(this.myMax)) {
                if (AllIntegersDocument.isNegative(theValue) && this.isGreaterThanOrEqualToMin(theValue)) {
                    this.myStatusHandler.printMessage("");
                    super.insertString(offs, numbersOnlyString, a);
                } else {
                    this.myStatusHandler.beep();
                    this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
                }
            } else if (AllIntegersDocument.isNegative(this.myMin) && !AllIntegersDocument.isNegative(this.myMax)) {
                if (this.isGreaterThanOrEqualToMin(theValue) && this.isLessThanOrEqualToMax(theValue)) {
                    this.myStatusHandler.printMessage("");
                    super.insertString(offs, numbersOnlyString, a);
                } else {
                    this.myStatusHandler.beep();
                    this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
                }
            } else if (!AllIntegersDocument.isNegative(theValue) && this.isLessThanOrEqualToMax(theValue)) {
                this.myStatusHandler.printMessage("");
                super.insertString(offs, numbersOnlyString, a);
            } else {
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            }
        }
        catch (NumberFormatException e) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("")) {
                if (this.allowEmpty) {
                    return true;
                }
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("The range value is not valid.");
                return false;
            }
            BigInteger proposedResult = new BigInteger(value);
            if (this.isLessThanOrEqualToMax(proposedResult) && this.isGreaterThanOrEqualToMin(proposedResult)) {
                return true;
            }
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("The range value is not valid.");
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        if (statusHandler == null) {
            throw new IllegalArgumentException("Status handler cannot be null");
        }
        this.myStatusHandler = statusHandler;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    private static boolean isNegative(BigInteger valueToCheck) {
        return valueToCheck.compareTo(BIGINT_ZERO) == -1;
    }

    private boolean isLessThanOrEqualToMax(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMax) <= 0;
    }

    private boolean isGreaterThanOrEqualToMin(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMin) >= 0;
    }
}

