/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DateListDocument
extends PlainDocument
implements FieldValidation {
    private static StatusInterface myStatus = null;
    private static String numberExpression = "[0-9]+";
    private static Pattern numberPattern = Pattern.compile(numberExpression);
    private static String dateExpression = "^(19|2[0-9])\\d\\d((01|03|05|07|08|10|12)(3[0-1]|[1-2][0-9]|0[1-9])|(04|06|09|11)(30|[1-2][0-9]|0[1-9])|(02)(2[0-8]|1[0-9]|0[1-9]))";
    private static String leapYearDateExpression = "^(19|2[0-9])\\d\\d((01|03|05|07|08|10|12)(3[0-1]|[1-2][0-9]|0[1-9])|(04|06|09|11)(30|[1-2][0-9]|0[1-9])|(02)([1-2][0-9]|0[1-9]))";
    private Pattern datePattern = Pattern.compile(dateExpression);
    private Pattern leapDatePatter = Pattern.compile(leapYearDateExpression);
    char[] myTokenCharacters = new char[]{' ', ',', '\t', '\n', '\r'};
    private Pattern tokenSplitter = Pattern.compile("[" + new String(this.myTokenCharacters) + "]+");
    char[] myAllowedCharacters = new char[]{'-', '*'};
    private boolean isEnabled = true;

    public DateListDocument() {
    }

    public DateListDocument(char[] theAllowedCharacters) {
        this.myAllowedCharacters = theAllowedCharacters;
    }

    private boolean isAllowed(char c) {
        if (c <= '9' && c >= '0') {
            return true;
        }
        if (this.myAllowedCharacters != null) {
            for (int i = 0; i < this.myAllowedCharacters.length; ++i) {
                if (this.myAllowedCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTokenChar(char c) {
        if (this.myTokenCharacters != null) {
            for (int i = 0; i < this.myTokenCharacters.length; ++i) {
                if (this.myTokenCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer buf = new StringBuffer();
        int start = 0;
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isAllowed(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            if (this.isTokenChar(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' allowed");
        }
        String numbersOnlyString = buf.toString();
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.myTokenCharacters != null) {
            String[] tokenArr = this.tokenSplitter.split(proposedResult);
            for (int ii = 0; ii < tokenArr.length; ++ii) {
                if (this.checkDate(tokenArr[ii], false)) continue;
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Date " + tokenArr[ii] + " is not valid");
                return;
            }
        } else if (!this.checkDate(proposedResult, false)) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Date " + proposedResult + " not valid");
            return;
        }
        super.insertString(offs, numbersOnlyString.toString(), a);
    }

    private boolean checkNumber(String aNumber) {
        return numberPattern.matcher(aNumber).matches();
    }

    private boolean checkRange(String aValue, boolean rigid) {
        if (aValue.indexOf("-") >= 0) {
            String start = aValue.substring(0, aValue.indexOf("-"));
            String end = aValue.substring(aValue.indexOf("-") + 1, aValue.length());
            if (rigid) {
                return this.isDateAllowed(start) && this.isDateAllowed(end) && start.length() == end.length() && end.compareTo(start) > 0;
            }
            return !(start.length() != 0 && !this.checkNumber(start) || end.length() != 0 && !this.checkNumber(end));
        }
        return false;
    }

    private boolean checkDate(String aDate, boolean rigid) {
        if (aDate.indexOf("-") >= 0) {
            return this.checkRange(aDate, rigid);
        }
        if (aDate.indexOf("*") >= 0) {
            return DateListDocument.checkWildCardDate(aDate, rigid);
        }
        if (rigid) {
            return this.isDateAllowed(aDate);
        }
        return this.checkNumber(aDate);
    }

    private boolean isDateAllowed(String aDate) {
        if (aDate.length() < 4) {
            return false;
        }
        String year = aDate.substring(0, 4);
        try {
            if (DateListDocument.isLeap(Integer.parseInt(year))) {
                return this.leapDatePatter.matcher(aDate).matches();
            }
            return this.datePattern.matcher(aDate).matches();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return true;
        }
        if (this.myTokenCharacters != null) {
            String[] tokenArr = this.tokenSplitter.split(value);
            for (int ii = 0; ii < tokenArr.length; ++ii) {
                if (this.checkDate(tokenArr[ii], true)) continue;
                return false;
            }
        } else if (!this.checkDate(value, true)) {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        myStatus = statusHandler;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    private static boolean isLeap(int year) {
        if (year % 100 == 0 && year % 400 != 0) {
            return false;
        }
        return year % 4 == 0;
    }

    private static boolean checkWildCardDate(String aDate, boolean rigid) {
        byte day;
        byte month;
        short year;
        if (!rigid) {
            return true;
        }
        int startPos = 0;
        int endPos = 0;
        try {
            if (aDate.indexOf(42) == 0) {
                ++endPos;
                year = -1;
            } else {
                String yyyy = aDate.substring(startPos, endPos += 4);
                year = Short.parseShort(yyyy);
            }
        }
        catch (Exception e) {
            return false;
        }
        if (endPos < aDate.length() && aDate.charAt(endPos) == '*') {
            ++endPos;
            month = -1;
        } else {
            startPos = endPos;
            if ((endPos += 2) > aDate.length()) {
                return false;
            }
            String mm = aDate.substring(startPos, endPos);
            try {
                month = Byte.parseByte(mm);
            }
            catch (NumberFormatException x) {
                return false;
            }
        }
        if (endPos > aDate.length()) {
            return false;
        }
        if (endPos < aDate.length() && aDate.charAt(endPos) == '*') {
            ++endPos;
            day = -1;
        } else {
            startPos = endPos;
            if ((endPos += 2) > aDate.length()) {
                return false;
            }
            String dd = aDate.substring(startPos, endPos);
            try {
                day = Byte.parseByte(dd);
            }
            catch (NumberFormatException x) {
                return false;
            }
        }
        if (endPos != aDate.length()) {
            if (myStatus != null) {
                RmaDefs.getInstance().controlledBeep();
                myStatus.printMessage("To many chars in '" + aDate + "'");
            }
            return false;
        }
        return DateListDocument.checkYear(year) && DateListDocument.checkMonth(month) && DateListDocument.checkDay(year, month, day);
    }

    private static boolean checkYear(short year) {
        return year == -1 || year > 1700 && year <= 9999;
    }

    private static boolean checkMonth(byte month) {
        return month == -1 || month > 0 && month <= 12;
    }

    private static boolean checkDay(short year, byte month, byte day) {
        if (day == -1) {
            return true;
        }
        int numDays = 31;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                numDays = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                numDays = 30;
                break;
            }
            case 2: {
                if (year == -1 || DateListDocument.isLeap(year)) {
                    numDays = 29;
                    break;
                }
                numDays = 28;
                break;
            }
            default: {
                numDays = 31;
            }
        }
        return day > 0 && day <= numDays;
    }
}

