/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.lang.reflect.Constructor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FileNameDocument
extends PlainDocument
implements FieldValidation {
    private boolean isEnabled = true;
    Class<?> myValueClass;
    transient Constructor<?> myValueStringConstructor = null;

    public FileNameDocument() {
        this.myValueClass = "".getClass();
        this.initialize();
    }

    public FileNameDocument(Class<?> c) {
        this.myValueClass = c;
        this.initialize();
    }

    private void initialize() {
        try {
            this.myValueStringConstructor = this.myValueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalArgumentException("String constructor not found for class: " + this.myValueClass);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int start;
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer buf = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = start = 0; i < chars.length; ++i) {
            if (this.isValidChar(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Character '" + chars[i] + "' is not allowed.");
        }
        String numbersOnlyString = buf.toString();
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            if (this.myValueStringConstructor == null) {
                this.initialize();
            }
            this.myValueStringConstructor.newInstance(proposedResult);
            super.insertString(offs, numbersOnlyString, a);
        }
        catch (Exception e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Illegal value: " + proposedResult + ", Details: " + e);
        }
    }

    public boolean isValidChar(char c) {
        if (c >= '!' && c <= 'z') {
            return c != '\"' && c != '&' && c != '\'' && c != '(' && c != ')' && c != '*' && c != '/' && c != ':' && c != ';' && c != '<' && c != '>' && c != '?' && c != '\\' && c != '^' && c != '`';
        }
        return false;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        for (char c : value.toCharArray()) {
            if (this.isValidChar(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }
}

