/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexAsciiDocument
extends PlainDocument
implements FieldValidation {
    Class<OctetString> myValueClass;
    transient Constructor<OctetString> myValueStringConstructor;
    boolean isHexMode = true;
    private boolean isEnabled = true;

    public HexAsciiDocument() {
        this.myValueClass = OctetString.class;
        this.initialize();
    }

    public HexAsciiDocument(Class<OctetString> c) {
        this.myValueClass = c;
        this.initialize();
    }

    private void initialize() {
        try {
            this.myValueStringConstructor = this.myValueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalArgumentException("String constructor not found for class: " + this.myValueClass);
        }
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        String currentString = super.getText(offset, length);
        if (this.isHexMode) {
            return OctetString.valueOf(currentString).toString();
        }
        return OctetString.fromAscii(currentString).toString();
    }

    public String getActualText(int offset, int length) throws BadLocationException {
        return super.getText(offset, length);
    }

    public boolean getMode() {
        return this.isHexMode;
    }

    public void setMode(boolean aMode) {
        this.isHexMode = aMode;
    }

    public boolean isHexDigit(char c) {
        if (c <= '9' && c >= '0') {
            return true;
        }
        if (c == 'a' || c == 'A') {
            return true;
        }
        if (c == 'b' || c == 'B') {
            return true;
        }
        if (c == 'c' || c == 'C') {
            return true;
        }
        if (c == 'd' || c == 'D') {
            return true;
        }
        if (c == 'e' || c == 'E') {
            return true;
        }
        return c == 'f' || c == 'F';
    }

    public void insertString(int offs, OctetString oStr, AttributeSet a) throws BadLocationException {
        StatusPanel.getInstance().setStatusMsg("");
        if (this.isHexMode) {
            this.insertHexString(offs, oStr.toString(), a);
        } else {
            this.insertAsciiString(offs, oStr.toAscii(), a);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        if (this.isHexMode) {
            this.insertHexString(offs, str, a);
        } else {
            this.insertAsciiString(offs, str, a);
        }
    }

    private void insertAsciiString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = super.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.isValid(proposedResult)) {
            super.insertString(offs, str, a);
        } else {
            StatusPanel.getInstance().setStatusMsg("The string '" + proposedResult + "' is not a valid US ASCII");
        }
    }

    private void insertHexString(int offs, String str, AttributeSet a) throws BadLocationException {
        String numbersOnlyString = "";
        int start = 0;
        int currLen = this.getLength();
        if (offs == 0 && currLen == 0) {
            if (str.startsWith("0x")) {
                numbersOnlyString = numbersOnlyString + "0x";
                start = 2;
            } else if (str.length() == 1 && str.charAt(0) == '0') {
                numbersOnlyString = numbersOnlyString + "0";
                start = 1;
            }
        }
        if (offs == 1 && currLen < 2 && str.length() != 0 && str.charAt(0) == 'x') {
            numbersOnlyString = numbersOnlyString + "x";
            start = 2;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isHexDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9a-f' allowed");
        }
        String currentText = super.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            if (this.myValueStringConstructor == null) {
                this.initialize();
            }
            this.myValueStringConstructor.newInstance(proposedResult);
            super.insertString(offs, numbersOnlyString, a);
        }
        catch (Exception e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Illegal value: " + proposedResult + ", Details: " + e);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.isHexMode) {
            return Pattern.matches("^(0[xX])?\\p{XDigit}*", value);
        }
        return Pattern.matches("[ -~]*", value);
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

