/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumbersOnlyDocument
extends PlainDocument
implements FieldValidation {
    private long myMin = Long.MIN_VALUE;
    private long myMax = Long.MAX_VALUE;
    private boolean minIsNegative = true;
    private boolean maxIsNegative = false;
    private boolean allowEmpty = false;
    private boolean allowZero = true;
    private boolean isEnabled = true;
    private StatusInterface myStatusHandler = new RMAStatusInterface();

    public NumbersOnlyDocument() {
    }

    public NumbersOnlyDocument(long min, long max) {
        this.myMin = min;
        this.myMax = max;
        this.calculateLimits();
    }

    public NumbersOnlyDocument(long min, long max, boolean empty) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = empty;
        this.calculateLimits();
    }

    public NumbersOnlyDocument(long min, long max, boolean empty, boolean zero) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = empty;
        this.allowZero = zero;
        this.calculateLimits();
    }

    public long getMinValue() {
        return this.myMin;
    }

    public void setMinValue(long v) {
        this.myMin = v;
        this.calculateLimits();
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, 0, DocumentEvent.EventType.CHANGE));
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(long v) {
        this.myMax = v;
        this.calculateLimits();
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, 0, DocumentEvent.EventType.CHANGE));
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        this.myStatusHandler.printMessage("");
        String numbersOnlyString = "";
        int start = 0;
        if (this.minIsNegative && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        if (str != null && str.length() > 0) {
            char[] chars = str.toCharArray();
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("Only digits '0-9' allowed");
            }
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0 && this.allowEmpty) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        try {
            long longProposedResult = Long.parseLong(proposedResult);
            if (this.minIsNegative && this.maxIsNegative) {
                if (longProposedResult < 0L && longProposedResult >= this.myMin) {
                    super.insertString(offs, numbersOnlyString, a);
                } else {
                    this.myStatusHandler.beep();
                    this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
                }
            } else if (this.minIsNegative && !this.maxIsNegative) {
                if (longProposedResult >= this.myMin && longProposedResult <= this.myMax) {
                    super.insertString(offs, numbersOnlyString, a);
                } else {
                    this.myStatusHandler.beep();
                    this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
                }
            } else if (longProposedResult >= 0L && longProposedResult <= this.myMax) {
                super.insertString(offs, numbersOnlyString, a);
            } else {
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            }
        }
        catch (NumberFormatException e) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("")) {
                return this.allowEmpty;
            }
            long longProposedResult = Long.parseLong(value);
            if (longProposedResult == 0L && !this.allowZero) {
                return false;
            }
            return longProposedResult <= this.myMax && longProposedResult >= this.myMin;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    private void calculateLimits() {
        this.minIsNegative = this.myMin < 0L;
        this.maxIsNegative = this.myMax < 0L;
    }
}

