/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.vareditor.document.LimitingDocument;
import ericsson.vareditor.documents.HexStringListDocument;

public class OctetHexStringListDocument
extends HexStringListDocument {
    public OctetHexStringListDocument(char[] separatorValues) {
        super(separatorValues);
    }

    @Override
    protected void testWholeText(String hexString) throws LimitingDocument.Rejection {
        if (!this.isValidOctetHexString(hexString)) {
            throw new LimitingDocument.Rejection("Not a valid octet hexadecimal string: " + hexString);
        }
    }

    private boolean isValidOctetHexString(String octetHexString) {
        boolean returnValue = false;
        if (octetHexString != null) {
            if (this.mySeparatorPattern != null) {
                returnValue = true;
                for (String hexString : this.mySeparatorPattern.split(octetHexString)) {
                    if (hexString.length() % 2 == 0) continue;
                    returnValue = false;
                    break;
                }
            } else {
                returnValue = octetHexString.length() % 2 == 0;
            }
        }
        return returnValue;
    }
}

