/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.datatype.interfaces.ExtendedAmountFactory;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.components.AmountVariablePanel;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.text.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AmountVariable
extends PanelVariable {
    public static final String DEFAULT_AMOUNT_STRING = "";
    public static final String AMOUNT_VARIABLE_LABEL = "Amount";
    public static final String AMOUNT_VARIABLE_TAG = "AmountVariable";
    public static final String AMOUNT_VARIABLE_VALUE_TAG = "Value";
    public static final String AMOUNT_VARIABLE_CURRENCY_TAG = "Currency";
    private static final String AMOUNT_VARIABLE_CURRENCYCODE_TAG = "CurrencyCode";
    private static final String AMOUNT_VARIABLE_NEGALLOWED_TAG = "NegativeInputAllowed";
    public static final int DEFAULT_MAX_LENGTH = 15;
    public static final int DEFAULT_DECIMALS = 6;
    private boolean myAllowNegative;
    private final boolean myAllowZero;
    private final RatingDecimal myMinValue;
    private final RatingDecimal myMaxValue;
    private final int myMaxLength;
    private final int myDecimals;
    private AmountFactory myAmountFactory = DefaultAmountFactory.getInstance();
    private boolean myEventsDisabled;

    public AmountVariable(AmountVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myAllowNegative = v.myAllowNegative;
        this.myAllowZero = v.myAllowZero;
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
        this.myMaxLength = v.myMaxLength;
        this.myDecimals = v.myDecimals;
        this.myAmountFactory = v.myAmountFactory;
    }

    public AmountVariable(String label, boolean allowNegative) {
        this(label, allowNegative, true);
    }

    public AmountVariable(String label, boolean allowNegative, boolean allowZero) {
        this(label, allowNegative, allowZero, null, null, 15, 6);
    }

    public AmountVariable(String label, boolean allowNegative, boolean allowZero, RatingDecimal minValue, RatingDecimal maxValue, int maxLength, int decimals) {
        this(label, DEFAULT_AMOUNT_STRING, allowNegative, allowZero, minValue, maxValue, maxLength, decimals);
    }

    public AmountVariable(String label, String value, boolean allowNegative) {
        this(label, value, allowNegative, true, null, null, 15, 6);
    }

    public AmountVariable(String label, String value, boolean allowNegative, boolean allowZero) {
        this(label, value, allowNegative, allowZero, null, null, 15, 6);
    }

    public AmountVariable(String label, String value, boolean allowNegative, boolean allowZero, RatingDecimal minValue, RatingDecimal maxValue, int maxLength, int decimals) {
        super(label, (Object)value);
        this.myAllowNegative = allowNegative;
        this.myAllowZero = allowZero;
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
        this.myMaxLength = maxLength;
        this.myDecimals = decimals;
    }

    public void setAllowNegative(boolean allow) {
        this.myAllowNegative = allow;
    }

    public void setAmountFactory(AmountFactory factory) {
        if (this.myValue instanceof Amount) {
            throw new IllegalStateException("The variable value has already been converted to an amount.");
        }
        this.myAmountFactory = factory;
    }

    @Override
    protected void fireValueChanged() {
        if (!this.myEventsDisabled) {
            super.fireValueChanged();
        }
    }

    protected void ensureCurrentValueIsAmountAndValidated() {
        if (!(this.myValue instanceof Amount)) {
            try {
                this.myValue = this.createValue((String)this.myValue);
                this.checkIfCurrentAmountIsValid();
            }
            catch (Exception e) {
                this.myValue = Amount.create(RatingDecimal.ZERO, DEFAULT_AMOUNT_STRING, this.myAmountFactory);
                this.myIsValid = false;
                String msg = "Attempting to initiate AmountVariable with an amount string of incorrect format";
                ExceptionUtil.handleException(e, "simulation", 1, msg, false);
            }
        }
    }

    private void checkIfCurrentAmountIsValid() {
        assert (this.myValue instanceof Amount);
        boolean allowed = true;
        RatingDecimal balance = ((Amount)this.myValue).getBalance();
        String currency = ((Amount)this.myValue).getCurrency();
        if (balance.isLessThanZero() && !this.myAllowNegative) {
            allowed = false;
        } else if (balance.isZero() && !this.myAllowZero) {
            allowed = false;
        } else if (this.myMinValue != null && balance.compareTo(this.myMinValue) < 0 || this.myMaxValue != null && balance.compareTo(this.myMaxValue) > 0) {
            allowed = false;
        } else if (currency.length() != 3) {
            allowed = false;
        }
        this.myIsValid = allowed;
    }

    private Amount createValue(String value) {
        Amount amount;
        String trimmed = value.trim();
        if (trimmed.equals(DEFAULT_AMOUNT_STRING)) {
            amount = this.myAmountFactory.create(RatingDecimal.ZERO, this.getDefaultCurrencyFromFactory());
        } else {
            try {
                amount = DataType.AmountStringParser.parseValue(trimmed, this.myAmountFactory);
            }
            catch (ParseException e) {
                amount = Amount.create(new RatingDecimal(trimmed), DEFAULT_AMOUNT_STRING, this.myAmountFactory);
            }
        }
        return amount;
    }

    protected String getDefaultCurrencyFromFactory() {
        String code = this.myAmountFactory instanceof ExtendedAmountFactory ? ((ExtendedAmountFactory)this.myAmountFactory).getDefaultCurrencyCode() : DefaultAmountFactory.getInstance().getDefaultCurrencyCode();
        return code;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        assert (this.myPanelVariableEditor == null);
        this.ensureCurrentValueIsAmountAndValidated();
        AmountVariablePanel panel = new AmountVariablePanel((Amount)this.myValue, this.myAllowNegative, this.myAllowZero, this.myMinValue, this.myMaxValue, this.myMaxLength, this.myDecimals, this.myAmountFactory);
        panel.setValue((Amount)this.myValue);
        return panel;
    }

    private boolean hasEditor() {
        return this.myPanelVariableEditor != null;
    }

    @Override
    protected void validate() {
        if (this.hasEditor()) {
            AmountVariablePanel panel = this.editor();
            boolean amountStringValid = panel.isAmountValid();
            boolean currencyStringValid = panel.isCurrencyValid();
            this.myIsValid = amountStringValid && currencyStringValid;
        } else {
            this.ensureCurrentValueIsAmountAndValidated();
        }
    }

    @Override
    public Object clone() {
        return new AmountVariable(this);
    }

    @Override
    public Object getValueObject() {
        this.ensureCurrentValueIsAmountAndValidated();
        return this.myValue;
    }

    @Override
    public String getValueString() {
        this.ensureCurrentValueIsAmountAndValidated();
        String s = String.valueOf(this.myValue);
        return s;
    }

    @Override
    protected void setVarValue(Object value) {
        if (value instanceof Amount) {
            if (this.hasEditor()) {
                this.setEditorValueWithoutFiring((Amount)value);
            } else {
                this.myValue = value;
                this.checkIfCurrentAmountIsValid();
            }
        } else if (value instanceof String) {
            this.setVarValue((String)value);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass().getName());
        }
    }

    private void setEditorValueWithoutFiring(Amount value) {
        try {
            this.myEventsDisabled = true;
            this.editor().setValue(value);
        }
        finally {
            this.myEventsDisabled = false;
        }
    }

    private AmountVariablePanel editor() {
        return (AmountVariablePanel)this.getPanelVariableEditor();
    }

    @Override
    protected void setVarValue(String value) {
        if (DEFAULT_AMOUNT_STRING.equals(value)) {
            return;
        }
        try {
            Amount amount = DataType.AmountStringParser.parseValue(value, this.myAmountFactory);
            this.setVarValue(amount);
        }
        catch (ParseException ex) {
            if (this.hasEditor()) {
                this.setEditorValueWithoutFiring(DefaultAmountFactory.getInstance().create(RatingDecimal.ZERO, DEFAULT_AMOUNT_STRING));
            }
            this.myIsValid = false;
            this.myValue = value;
        }
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        Element negativeElement;
        NodeList childNodes = node.getChildNodes();
        Element amountVarNode = XMLUtil.getNamedElement(AMOUNT_VARIABLE_TAG, childNodes);
        Element valueElement = XMLUtil.getFirstElementNamed(AMOUNT_VARIABLE_VALUE_TAG, amountVarNode);
        Element currencyElement = XMLUtil.getFirstElementNamed(AMOUNT_VARIABLE_CURRENCY_TAG, amountVarNode);
        if (currencyElement == null) {
            currencyElement = XMLUtil.getFirstElementNamed(AMOUNT_VARIABLE_CURRENCYCODE_TAG, amountVarNode);
        }
        if ((negativeElement = XMLUtil.getFirstElementNamed(AMOUNT_VARIABLE_NEGALLOWED_TAG, amountVarNode)) != null) {
            boolean allowed = Boolean.parseBoolean(XMLUtil.getFirstTextContent(negativeElement));
            this.setAllowNegative(allowed);
        }
        Amount amount = this.createAmount(valueElement.getTextContent(), currencyElement.getTextContent());
        this.setVarValue(amount);
    }

    private Amount createAmount(String amount, String currency) {
        return this.myAmountFactory.create(new RatingDecimal(amount), currency);
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
        out.print("<AmountVariable>");
        out.print(XMLUtil.wrapInTag(AMOUNT_VARIABLE_VALUE_TAG, this.editor().getAmountString().trim()));
        out.print(XMLUtil.wrapInTag(AMOUNT_VARIABLE_CURRENCYCODE_TAG, this.editor().getCurrencyString().trim()));
        out.print(XMLUtil.wrapInTag(AMOUNT_VARIABLE_NEGALLOWED_TAG, Boolean.toString(this.myAllowNegative)));
        out.print("</AmountVariable>");
    }

    @Override
    public void setFocusListenerForEditor(FocusListener fl) {
        super.setFocusListenerForEditor(fl);
        this.editor().setFocusListenerForEditor(fl);
    }

    public static String ExtractAmountFactoryClass(Node fieldNode) {
        Element factoryNode;
        if (fieldNode != null && (factoryNode = XMLUtil.getFirstElementNamed("AmountFactoryClass", (Element)fieldNode)) != null) {
            return factoryNode.getTextContent();
        }
        return DEFAULT_AMOUNT_STRING;
    }

    public static String ExtractAllowNegativeInput(Node fieldNode) {
        Element allowNegativeNode;
        if (fieldNode != null && (allowNegativeNode = XMLUtil.getFirstElementNamed("AllowNegativeInput", (Element)fieldNode)) != null) {
            return allowNegativeNode.getTextContent();
        }
        return DEFAULT_AMOUNT_STRING;
    }

    @Override
    public String getTypename() {
        return AMOUNT_VARIABLE_LABEL;
    }

    public Class<Amount> getValueClass() {
        return Amount.class;
    }
}

