/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ArrayEditPanel;
import com.ericsson.ere.gui.util.ArrayEditPanelBuilder;
import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ArrayEditDialog
extends JDialog {
    static final String ACTION_CLOSE = "Done";
    private ArrayEditPanel myEditPanel;

    public ArrayEditDialog(Window owner, ArrayVariable aVariable) {
        this(owner, aVariable, DataType.STRING);
    }

    public ArrayEditDialog(Window owner, ArrayVariable aVariable, ValueResolver valueResolver) {
        this(owner, aVariable, valueResolver, false);
    }

    public ArrayEditDialog(Window owner, ArrayVariable aVariable, ValueResolver valueResolver, boolean forceEditArray) {
        this(owner, "Array Edit for " + aVariable.getLabel(), ArrayEditPanelBuilder.useModel(aVariable.getModel()).withValueResolver(valueResolver).withVariableProducer(aVariable.getVariableProducer()).withObjectLabeler(aVariable.getObjectLabeler()).forceArrayEdit(forceEditArray));
    }

    public ArrayEditDialog(Window owner, String title, ArrayEditPanelBuilder panelBuilder) {
        super(owner, title, JDialog.DEFAULT_MODALITY_TYPE);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ArrayEditDialog.this.validateInputOnClose();
            }
        });
        JButton closeButton = new JButton(new CloseAction());
        closeButton.setName("ArrayEditDialog.JButton.CloseButton");
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.add(closeButton);
        this.myEditPanel = panelBuilder.createPanel();
        this.myEditPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "_escape");
        this.myEditPanel.getActionMap().put("_escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayEditDialog.this.validateInputOnClose();
            }
        });
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.add((Component)this.myEditPanel, "Center");
        dialogPanel.add((Component)closeButtonPanel, "South");
        this.getContentPane().add(dialogPanel);
        this.getRootPane().setDefaultButton(closeButton);
        this.pack();
        this.setName("ArrayEditDialog");
    }

    public JTable getTable() {
        return this.myEditPanel.getTable();
    }

    public void setEditMode(ArrayVariable.EditMode mode) {
        this.myEditPanel.setEditMode(mode);
    }

    ArrayEditPanel getEditPanel() {
        return this.myEditPanel;
    }

    @Override
    public void setVisible(boolean show) {
        if (show && this.myEditPanel != null) {
            this.myEditPanel.setInitialState();
        }
        super.setVisible(show);
    }

    protected void validateInputOnClose() {
        ArrayModel model = (ArrayModel)this.myEditPanel.getTable().getModel();
        this.myEditPanel.cleanupModel(model);
        this.setVisible(false);
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(ArrayEditDialog.ACTION_CLOSE);
            this.putValue("ActionCommandKey", ArrayEditDialog.ACTION_CLOSE);
            this.putValue("ShortDescription", "Stop editing");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayEditDialog.this.validateInputOnClose();
            ArrayEditDialog.this.dispose();
        }
    }
}

