/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.simulation.ArrayValueBuilder;
import ericsson.ere.xml.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Node;

public class ArrayModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5214381314388010995L;
    private ArrayList<Object> myColumns;
    private String[] myColumnNames = null;
    private Class<?>[] myColumnClasses = new Class[]{Object.class, Object.class};
    private short myNumberOfDimensions = 1;
    private boolean myIsModified = false;
    private boolean myIsFixedLength = false;
    private boolean isReadOnly = false;
    private int myMaxNumberOfRows = -1;
    private Map<Class<?>, ValueResolver> myValueResolvers = new HashMap();

    public ArrayModel(Object[] valueColumns) {
        this.init(valueColumns);
    }

    public ArrayModel(Object[] valueColumns, String[] parColumnNames) {
        this.myColumnNames = parColumnNames;
        this.init(valueColumns);
    }

    public void setValueResolverForValueClass(Class<?> valueClass, ValueResolver valueResolver) {
        if (valueClass == null || valueResolver == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        boolean found = false;
        for (int i = 0; i < this.getColumnCount() && !found; ++i) {
            Class<?> colClass = this.getColumnClass(i);
            if (colClass != valueClass) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("No column class matches " + valueClass.getName());
        }
        this.myValueResolvers.put(valueClass, valueResolver);
    }

    private void init(Object[] valueColumns) {
        int i;
        int nCol = valueColumns.length;
        int nRow = 0;
        if (nCol > 0) {
            if (valueColumns[0] != null && valueColumns[0].getClass().isArray()) {
                Object col;
                this.myNumberOfDimensions = (short)2;
                this.myColumnClasses = new Class[nCol];
                for (i = 0; i < nCol; ++i) {
                    col = (Object[])valueColumns[i];
                    this.myColumnClasses[i] = this.getClassFromArray((Object[])col);
                }
                this.myColumns = new ArrayList(nCol);
                for (i = 0; i < nCol; ++i) {
                    col = (Object[])valueColumns[i];
                    if (nRow < ((Object[])col).length) {
                        nRow = ((Object[])col).length;
                    }
                    ArrayList<Object> column = new ArrayList<Object>(nRow);
                    for (int j = 0; j < nRow; ++j) {
                        column.add(col[j]);
                    }
                    this.myColumns.add(column);
                }
                for (i = 0; i < nCol; ++i) {
                    col = (ArrayList)this.myColumns.get(i);
                    if (((ArrayList)col).size() < nRow) {
                        ((ArrayList)col).ensureCapacity(nRow);
                        for (int j = ((ArrayList)col).size(); j < nRow; ++j) {
                            ((ArrayList)col).add(null);
                        }
                        continue;
                    }
                    if (((ArrayList)col).size() <= nRow) continue;
                    throw new IllegalArgumentException("Internal error! col.size() > nRow");
                }
            } else {
                this.myColumnClasses = new Class[2];
                this.myColumnClasses[0] = Integer.class;
                this.myColumnClasses[1] = this.getArrayClass(valueColumns);
                nRow = valueColumns.length;
                this.myColumns = new ArrayList(nRow);
                for (i = 0; i < nRow; ++i) {
                    this.myColumns.add(valueColumns[i]);
                }
            }
        } else {
            this.myColumnClasses = new Class[2];
            this.myColumnClasses[0] = Integer.class;
            this.myColumnClasses[1] = valueColumns.getClass().getComponentType();
            this.myColumns = new ArrayList();
        }
        for (i = 0; i < this.myColumnClasses.length; ++i) {
            if (!this.myColumnClasses[i].isArray()) continue;
            throw new IllegalArgumentException("Too many dimensions for ArrayModel");
        }
    }

    private Class<?> getClassFromArray(Object[] col) {
        Class<Object> foundClass = null;
        for (int j = 0; foundClass == null && j < col.length; ++j) {
            if (col[j] == null) continue;
            foundClass = col[j].getClass();
        }
        if (foundClass == null) {
            foundClass = col.getClass().getComponentType();
        } else if (EREDate.class.isAssignableFrom(foundClass)) {
            foundClass = EREDate.class;
        }
        return foundClass;
    }

    private Class<?> getArrayClass(Object[] array) {
        for (Object o : array) {
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            if (EREDate.class.isAssignableFrom(clazz)) {
                return EREDate.class;
            }
            return clazz;
        }
        return Object.class;
    }

    public short getNumberOfDimensions() {
        return this.myNumberOfDimensions;
    }

    public boolean isFixedLength() {
        return this.myIsFixedLength;
    }

    public void setFixedLength(boolean isFixed) {
        this.myIsFixedLength = isFixed;
    }

    @Override
    public int getRowCount() {
        switch (this.myNumberOfDimensions) {
            case 1: {
                return this.myColumns.size();
            }
            case 2: {
                List firstCol = (List)this.myColumns.get(0);
                return firstCol.size();
            }
        }
        throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
    }

    @Override
    public int getColumnCount() {
        return this.myColumnClasses.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (this.myNumberOfDimensions) {
            case 1: {
                switch (col) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        return this.myColumns.get(row);
                    }
                }
                throw new IllegalArgumentException("Too many columns for 1-dimensional ArrayModel: " + col);
            }
            case 2: {
                List colList = (List)this.myColumns.get(col);
                return colList.get(row);
            }
        }
        throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
    }

    public Object[] toArray() {
        Object[] retArray;
        switch (this.myNumberOfDimensions) {
            case 1: {
                Object[] arraytype = (Object[])Array.newInstance(this.myColumnClasses[1], 0);
                retArray = this.myColumns.toArray(arraytype);
                break;
            }
            case 2: {
                int len = this.myColumns.size();
                retArray = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object[] arraytype = (Object[])Array.newInstance(this.myColumnClasses[i], 0);
                    List colList = (List)this.myColumns.get(i);
                    retArray[i] = colList.toArray(arraytype);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
        return retArray;
    }

    public Object[] toOneDimensionalArray() {
        if (this.possibleToConvertToOneDimensionalArray()) {
            Object[] oneDimArray;
            Object[] arraytype = (Object[])Array.newInstance(this.myColumnClasses[1], 0);
            switch (this.myNumberOfDimensions) {
                case 1: {
                    oneDimArray = this.myColumns.toArray(arraytype);
                    break;
                }
                case 2: {
                    oneDimArray = ((List)this.myColumns.get(1)).toArray(arraytype);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
                }
            }
            return oneDimArray;
        }
        throw new IllegalStateException("Cannot convert model to one dimensional array");
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        switch (this.myNumberOfDimensions) {
            case 1: {
                Object[] data = this.toArray();
                for (int i = 0; i < data.length; ++i) {
                    map.put(i, data[i]);
                }
                break;
            }
            case 2: {
                int rows = this.getRowCount();
                int colCount = this.myColumns.size();
                for (int i = 0; i < rows; ++i) {
                    Object value;
                    Object key = ((List)this.myColumns.get(0)).get(i);
                    if (colCount > 2) {
                        ArrayList values = new ArrayList(colCount - 1);
                        for (int j = 0; j < colCount - 1; ++j) {
                            values.add(((List)this.myColumns.get(1 + j)).get(i));
                        }
                        value = values;
                    } else {
                        value = ((List)this.myColumns.get(1)).get(i);
                    }
                    map.put(key, value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
        return map;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        this.writeXML(out);
        out.close();
        try {
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.myColumnClasses[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean retVal = false;
        switch (this.myNumberOfDimensions) {
            case 1: {
                if (col != 1) break;
                retVal = !this.isReadOnly;
                break;
            }
            case 2: {
                retVal = !this.isReadOnly;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
        return retVal;
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void resetModified() {
        this.myIsModified = false;
    }

    public void setModified(boolean isModified) {
        this.myIsModified = isModified;
    }

    public void setReadOnly(boolean val) {
        this.isReadOnly = val;
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        this.myIsModified = true;
        try {
            switch (this.myNumberOfDimensions) {
                case 1: {
                    this.myColumns.set(row, val);
                    break;
                }
                case 2: {
                    List colVal = (List)this.myColumns.get(col);
                    colVal.set(row, val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
                }
            }
            this.fireTableCellUpdated(row, col);
        }
        catch (ArrayStoreException x) {
            System.out.println("ArrayStoreException: " + x.toString());
        }
    }

    public void add(Object o) {
        this.addRow(new Object[]{o});
    }

    public void addRow(Object[] rowdata) {
        this.insertRow(this.getRowCount(), rowdata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertRow(int index, Object[] rowdata) {
        this.myIsModified = true;
        switch (this.myNumberOfDimensions) {
            case 1: {
                if (rowdata.length > 0) {
                    Class<?> expected = this.myColumnClasses[1];
                    Class<?> gotten = rowdata[0].getClass();
                    if (!expected.isAssignableFrom(gotten)) throw new IllegalArgumentException("Mismatched types in addRow, expected: " + expected + ", but got: " + gotten);
                    this.myColumns.add(index, rowdata[0]);
                } else {
                    this.myColumns.add(index, null);
                }
                this.fireTableRowsInserted(index, index);
                return;
            }
            case 2: {
                List col;
                int i;
                if (rowdata.length <= this.myColumnClasses.length) {
                    for (i = 0; i < rowdata.length; ++i) {
                        Class<?> gotten;
                        Class<?> expected = this.myColumnClasses[i];
                        if (rowdata[i] == null || expected.isAssignableFrom(gotten = rowdata[i].getClass())) continue;
                        throw new IllegalArgumentException("Mismatched types in addRow[" + i + "], expected: " + expected + ", but got: " + gotten);
                    }
                }
                for (i = 0; i < rowdata.length; ++i) {
                    col = (List)this.myColumns.get(i);
                    col.add(index, rowdata[i]);
                }
                for (i = rowdata.length; i < this.myColumnClasses.length; ++i) {
                    col = (List)this.myColumns.get(i);
                    col.add(index, null);
                }
                this.fireTableRowsInserted(index, index);
                return;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
    }

    public void removeRow(int row) {
        this.myIsModified = true;
        switch (this.myNumberOfDimensions) {
            case 1: {
                this.myColumns.remove(row);
                break;
            }
            case 2: {
                for (int i = 0; i < this.myColumnClasses.length; ++i) {
                    ArrayList col = (ArrayList)this.myColumns.get(i);
                    col.remove(row);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public String getColumnName(int col) {
        return this.myColumnNames == null ? super.getColumnName(col) : this.myColumnNames[col];
    }

    public String[] getColumnNames() {
        return this.myColumnNames;
    }

    public void setColumnNames(String[] names) {
        this.myColumnNames = names;
        this.fireTableStructureChanged();
    }

    public void writeXML(PrintWriter out) {
        int i;
        out.printf("<Array dimensions=\"%d\">\n", this.myNumberOfDimensions);
        out.println("<Columns>");
        for (i = 0; i < this.getColumnCount(); ++i) {
            out.printf("<Column%s%s/>\n", XMLUtil.wrapInAttribute("name", this.getColumnName(i)), XMLUtil.wrapInAttribute("class", this.getColumnClass(i).getName()));
        }
        out.println("</Columns>");
        switch (this.myNumberOfDimensions) {
            case 1: {
                if (this.myColumns.size() > 0) {
                    out.println("<Data>");
                    this.printObjectList(out, this.myColumns, this.getColumnClass(1));
                    out.println("</Data>");
                    break;
                }
                out.println("<Data/>");
                break;
            }
            case 2: {
                for (i = 0; i < this.myColumns.size(); ++i) {
                    ArrayList col = (ArrayList)this.myColumns.get(i);
                    if (col.size() > 0) {
                        out.println("<Data>");
                        this.printObjectList(out, col, this.getColumnClass(i));
                        out.println("</Data>");
                        continue;
                    }
                    out.println("<Data/>");
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel");
            }
        }
        out.println("</Array>");
    }

    private void printObjectList(PrintWriter out, Iterable<?> list, Class<?> columnClass) {
        for (Object o : list) {
            if (o == null) {
                out.println("<null/>");
                continue;
            }
            ValueResolver resolver = this.myValueResolvers.get(columnClass);
            String value = resolver != null ? resolver.makeValueString(o) : o.toString();
            out.println(XMLUtil.wrapInTag("value", value));
        }
    }

    @Deprecated
    public static ArrayModel create(Node iterator) throws Exception {
        ArrayValueBuilder.ArrayValueResultContainer result = ArrayValueBuilder.create(iterator);
        ArrayModel retVal = new ArrayModel(result.getValues());
        retVal.setColumnNames(result.getColumnNames());
        return retVal;
    }

    public static ArrayModel create(Node config, Map<Class<?>, ValueResolver> valueResolvers) throws Exception {
        ArrayValueBuilder builder = new ArrayValueBuilder();
        for (Map.Entry<Class<?>, ValueResolver> entry : valueResolvers.entrySet()) {
            builder = builder.withValueResolverForValueClass(entry.getKey(), entry.getValue());
        }
        ArrayValueBuilder.ArrayValueResultContainer result = builder.build(config);
        ArrayModel model = new ArrayModel(result.getValues(), result.getColumnNames());
        for (Map.Entry<Class<?>, ValueResolver> entry : valueResolvers.entrySet()) {
            model.setValueResolverForValueClass(entry.getKey(), entry.getValue());
        }
        return model;
    }

    public void setValueColumn(Object[] value, int col) {
        this.myColumns.remove(col);
        this.myColumns.add(col, value);
    }

    public void setMaxNumberOfRows(int max) {
        this.myMaxNumberOfRows = max;
    }

    public int getMaxNumberOfRows() {
        return this.myMaxNumberOfRows;
    }

    public boolean possibleToConvertToOneDimensionalArray() {
        if (this.myNumberOfDimensions < 2) {
            return true;
        }
        boolean firstColumnIsInteger = this.myColumnClasses[0] == Integer.class;
        boolean firstColumnValuesAreAscending = ArrayModel.arrayContainsAscendingNumbers((List)this.myColumns.get(0));
        return firstColumnIsInteger && firstColumnValuesAreAscending;
    }

    public boolean rowHasDuplicateInColumn(int row, int column) {
        boolean hasDuplicate = false;
        switch (this.myNumberOfDimensions) {
            case 1: {
                if (column == 0) break;
                if (column == 1) {
                    hasDuplicate = this.rowHasDuplicateInColumn(row, this.myColumns);
                    break;
                }
                throw new IllegalArgumentException("Invalid column number in ArrayModel: " + column);
            }
            case 2: {
                if (column >= 0 && column < this.myColumns.size()) {
                    hasDuplicate = this.rowHasDuplicateInColumn(row, (List)this.myColumns.get(column));
                    break;
                }
                throw new IllegalArgumentException("Invalid column number in ArrayModel: " + column);
            }
            default: {
                throw new IllegalStateException("Wrong number of dimensions in ArrayModel");
            }
        }
        return hasDuplicate;
    }

    ArrayModel createEmptyModelOfCurrentType() {
        ArrayModel model;
        if (this.myNumberOfDimensions == 1) {
            model = new ArrayModel((Object[])Array.newInstance(this.myColumnClasses[1], 0));
        } else {
            Object[] array = new Object[]{Array.newInstance(this.myColumnClasses[0], 0), Array.newInstance(this.myColumnClasses[1], 0)};
            model = new ArrayModel(array);
        }
        return model;
    }

    private boolean rowHasDuplicateInColumn(int row, List<?> column) {
        boolean foundDuplicate = false;
        if (row < column.size()) {
            Object currentObject = column.get(row);
            for (int i = 0; i < column.size(); ++i) {
                if (i == row || !currentObject.equals(column.get(i))) continue;
                foundDuplicate = true;
                break;
            }
        }
        return foundDuplicate;
    }

    private static boolean arrayContainsAscendingNumbers(List<Object> valueList) {
        int expectedValue = 0;
        for (Object value : valueList) {
            if (value instanceof Integer && value.equals(expectedValue)) {
                ++expectedValue;
                continue;
            }
            return false;
        }
        return true;
    }

    public void removeTableModelListeners() {
        Object[] listenerList = this.listenerList.getListenerList();
        for (int i = 0; i < listenerList.length; ++i) {
            if (!(listenerList[i] instanceof TableModelListener)) continue;
            super.removeTableModelListener((TableModelListener)listenerList[i]);
        }
    }
}

