/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.vareditor.variable.ConstrainableVariable;
import ericsson.vareditor.variable.ContainerVariable;
import ericsson.vareditor.variable.ValueFieldPanel;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompositeValueVariable
extends ContainerVariable
implements ConstrainableVariable {
    public CompositeValueVariable(List<FieldDefinition> fields, ClassRepository repository, List<ValueFieldCompositeObject> values, String indexLabel) {
        this(fields, repository, values, indexLabel, IndexVariableFactory.buildFactory().withRepository(repository));
    }

    public CompositeValueVariable(List<FieldDefinition> fields, ClassRepository repository, String indexLabel) {
        this(fields, repository, null, indexLabel);
    }

    private CompositeValueVariable(List<FieldDefinition> fields, ClassRepository repository, List<ValueFieldCompositeObject> values, String indexLabel, IndexVariableFactory factory) {
        super(indexLabel, new Variable[0]);
        this.myVariables = new ArrayList();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDefinition originalField = fields.get(i);
            FieldDefinition fieldWrapper = CompositeValueVariable.createSimpleKeyFieldWrapper(originalField);
            ValueFieldCompositeObject initialValue = values != null ? values.get(i) : FieldOrientedPluginUtil.createDefaultValueFieldCompositeObjectForFieldKey(fieldWrapper, repository);
            Variable v = factory.createIndexVariableForField(originalField.getFieldName(), null, fieldWrapper, initialValue);
            v.setDataItem(this);
            this.myVariables.add(v);
        }
    }

    private static FieldDefinition createSimpleKeyFieldWrapper(final FieldDefinition field) {
        return FieldDefinition.createField(field.getParent(), new FieldDefinition.FieldConfiguration(){

            @Override
            public List<String> getContexts() {
                return field.getContextNames();
            }

            @Override
            public Node getFieldNode() {
                Element node = (Element)field.getDefinitionNode();
                node.setAttribute("ComplexType", "MAP");
                return node;
            }

            @Override
            public String getKeyField() {
                return field.getCanonicalName();
            }
        }, true);
    }

    @Override
    public Object getValueObject() {
        ArrayList<ValueFieldCompositeObject> vfcos = new ArrayList<ValueFieldCompositeObject>();
        for (Variable v : this.myVariables) {
            vfcos.add(FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(v));
        }
        return new MultipleValueFieldCompositeObject(vfcos);
    }

    @Override
    protected void setEditorValue() {
        if (this.myPanelVariableEditor != null) {
            ((ValueFieldPanel)this.myPanelVariableEditor).setEditorValue((MultipleValueFieldCompositeObject)this.getValueObject());
        }
    }

    @Override
    public void constrainApplicableFields(Constrainable constrainable, ClassRepository repository, List<FieldDefinition> candidateFields) {
        for (Variable v : this.myVariables) {
            if (!(v instanceof ConstrainableVariable)) continue;
            ((ConstrainableVariable)((Object)v)).constrainApplicableFields(constrainable, repository, candidateFields);
        }
    }

    public static CompositeValueVariableBuilder buildVariable() {
        return new CompositeValueVariableBuilder();
    }

    public static class CompositeValueVariableBuilder {
        private String myOwnLabel;
        private String myOwnKey;
        private List<FieldDefinition> myOwnKeyFieldList;
        private List<ValueFieldCompositeObject> myOwnInitialValue;
        private IndexVariableFactory myOwnFactory;

        public CompositeValueVariableBuilder withLabel(String label) {
            this.myOwnLabel = label;
            return this;
        }

        public CompositeValueVariableBuilder withKey(String key) {
            this.myOwnKey = key;
            return this;
        }

        public CompositeValueVariableBuilder withKeyFields(List<FieldDefinition> keyFieldList) {
            this.myOwnKeyFieldList = keyFieldList;
            return this;
        }

        public CompositeValueVariableBuilder withInitialValue(List<ValueFieldCompositeObject> initialValue) {
            this.myOwnInitialValue = initialValue;
            return this;
        }

        public CompositeValueVariableBuilder withIndexVariableFactory(IndexVariableFactory factory) {
            this.myOwnFactory = factory;
            return this;
        }

        public CompositeValueVariable andClassRepository(ClassRepository repository) {
            if (this.anyValueIsNull(this.myOwnLabel, this.myOwnKeyFieldList, repository)) {
                throw new IllegalStateException("Builder has not been initialized with all needed values");
            }
            CompositeValueVariable variable = new CompositeValueVariable(this.myOwnKeyFieldList, repository, this.myOwnInitialValue, this.myOwnLabel, this.myOwnFactory);
            if (this.myOwnKey != null) {
                variable.setKey(this.myOwnKey);
            }
            return variable;
        }

        private boolean anyValueIsNull(Object ... objects) {
            boolean aValueWasNull = false;
            for (int i = 0; i < objects.length; ++i) {
                aValueWasNull |= objects[i] == null;
            }
            return aValueWasNull;
        }
    }
}

