/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ContainerVariable
extends PanelVariable
implements DataItem {
    protected List<Variable> myVariables;
    private RelationshipValidator myValidator;

    public ContainerVariable(String label, RelationshipValidator validator, List<Variable> vars) {
        super(label);
        this.myVariables = vars;
        this.myValidator = validator;
        for (Variable var : vars) {
            var.setDataItem(this);
        }
    }

    public ContainerVariable(String label, RelationshipValidator validator, Variable ... vars) {
        this(label, validator, Arrays.asList(vars));
    }

    public ContainerVariable(String label, List<Variable> vars) {
        this(label, null, vars);
    }

    public ContainerVariable(String label, Variable ... vars) {
        this(label, null, Arrays.asList(vars));
    }

    public ContainerVariable(PanelVariable v) {
        super(v);
        if (!(v instanceof ContainerVariable)) {
            throw new IllegalArgumentException("Argument v is not a ContainerVariable.");
        }
        ContainerVariable cv = (ContainerVariable)v;
        this.myVariables = new ArrayList<Variable>();
        for (Variable var : cv.myVariables) {
            Variable cloneVar = (Variable)var.clone();
            cloneVar.setDataItem(this);
            this.myVariables.add(cloneVar);
        }
        this.myValidator = cv.myValidator;
    }

    @Override
    public Class<?> getValueClass() {
        return List.class;
    }

    @Override
    public Object getValueObject() {
        return this.myVariables;
    }

    @Override
    public String getValueString() {
        StringBuffer sb = new StringBuffer();
        for (Variable var : this.myVariables) {
            sb.append(String.format("%s: [%s] ", var.getLabel(), var.getValueString()));
        }
        return sb.toString().trim();
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof List) {
            List theList = (List)v;
            for (Variable var : this.myVariables) {
                Variable setter = VarListUtil.getVariableForKey(theList, var.getKey());
                if (setter == null) {
                    throw new UnsupportedOperationException("The passed variable list does not contain a variable with key " + var.getKey());
                }
                if (!setter.getTypename().equals(var.getTypename())) {
                    throw new UnsupportedOperationException("The passed variable with key " + var.getKey() + " does not have the same type as the existing one.");
                }
                var.setValue(setter.getValueObject());
            }
        } else {
            throw new UnsupportedOperationException("Provided object to be set in ContainerVariable is not a List.");
        }
    }

    @Override
    protected void setVarValue(String v) {
        throw new UnsupportedOperationException("ContainerVariable doesn't support setting the variable value.");
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new ContainerVariablePanel();
    }

    @Override
    protected void validate() {
        String invalidText = null;
        for (Variable currentVariable : this.myVariables) {
            if (currentVariable.isValueValid()) continue;
            invalidText = "'" + this.getLabel() + " - " + currentVariable.getLabel() + "' value is invalid.";
        }
        if (invalidText == null && this.myValidator != null) {
            invalidText = this.myValidator.validateRelationship(this.myVariables);
        }
        StatusPanel.getInstance().setStatusMsg(invalidText == null ? "" : invalidText);
        this.setValid(invalidText == null);
        if (this.myPanelVariableEditor != null) {
            ((ContainerVariablePanel)this.getEditor()).setValid(invalidText == null);
        }
    }

    @Override
    public Object clone() {
        return new ContainerVariable(this);
    }

    public Variable getVariableAt(int i) {
        return this.myVariables.get(i);
    }

    public int getVariableCount() {
        return this.myVariables.size();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("DataItem method not supported.");
    }

    @Override
    public Object getDataItem(Object reference) {
        throw new UnsupportedOperationException("DataItem method not supported.");
    }

    @Override
    public Object getDataItem() {
        throw new UnsupportedOperationException("DataItem method not supported.");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("DataItem method not supported.");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("DataItem method not supported.");
    }

    @Override
    public void addVariableChangeListener(VariableChangeListener listener) {
        super.addVariableChangeListener(listener);
        for (int i = 0; i < this.getVariableCount(); ++i) {
            this.getVariableAt(i).addVariableChangeListener(listener);
        }
    }

    @Override
    public void removeVariableChangeListener(VariableChangeListener listener) {
        super.removeVariableChangeListener(listener);
        for (int i = 0; i < this.getVariableCount(); ++i) {
            this.getVariableAt(i).removeVariableChangeListener(listener);
        }
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        this.setDataItem(object);
    }

    @Override
    public void setDataItem(Object object) {
        this.validate();
        this.fireValueChanged();
    }

    private class ContainerVariablePanel
    extends AbstractPanelVariableEditor {
        private static final long serialVersionUID = 1L;
        private Border myValidBorder;
        private Border myInvalidBorder;

        public ContainerVariablePanel() {
            super(new BorderLayout());
            this.myValidBorder = new EmptyBorder(2, 2, 2, 2);
            this.myInvalidBorder = new LineBorder(Color.red, 2);
            VarTable2 table = new VarTable2();
            table.setTableModel(new VarTableModel(ContainerVariable.this.myVariables));
            this.setBorder(this.myValidBorder);
            this.add((Component)table, "Center");
        }

        @Override
        public Object getEditorValue() {
            return null;
        }

        @Override
        public boolean isEditorValueValid() {
            return true;
        }

        public void setValid(boolean valid) {
            this.setBorder(valid ? this.myValidBorder : this.myInvalidBorder);
        }
    }

    public static interface RelationshipValidator {
        public String validateRelationship(List<Variable> var1);
    }
}

