/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.variable.BaseVariable;
import java.awt.Component;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Node;

@Deprecated
public class DateVariable
extends BaseVariable
implements ChangeListener {
    protected Date myValue;
    protected JSpinner myRenderer = null;
    protected JSpinner myEditor = null;
    protected SpinnerDateModel myModel = null;

    public DateVariable(String label) {
        super(label);
        this.myValue = null;
    }

    public DateVariable(String label, Date value) {
        super(label);
        this.myValue = value;
    }

    public DateVariable(String label, Calendar value) {
        super(label);
        this.myValue = value.getTime();
    }

    public DateVariable(String label, String value) {
        super(label);
        String v = value;
        if (v.length() == 0) {
            this.myValue = new Date();
        } else {
            try {
                this.myValue = DateUtil.stringToDate(v, this.getDateFormat());
            }
            catch (ParseException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public DateVariable(DateVariable v) {
        super(v);
        this.myValue = v.myValue;
    }

    @Override
    public Object clone() {
        return new DateVariable(this);
    }

    protected String[] getDateFormat() {
        return DateUtil.DATE_TEXT_FORMAT;
    }

    @Override
    public Object getValueObject() {
        return this.myValue;
    }

    @Override
    public String getTypename() {
        return "Date";
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    public Class<Date> getValueClass() {
        return Date.class;
    }

    @Override
    public int getFormat() {
        return 9;
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            if (this.myModel == null) {
                this.myModel = new SpinnerDateModel();
                this.myModel.addChangeListener(this);
            }
            this.myRenderer = new JSpinner(this.myModel);
            JSpinner.DateEditor editor = new JSpinner.DateEditor(this.myRenderer, this.getDateFormat()[0]);
            this.myRenderer.setEditor(editor);
        }
        this.myModel.setValue(this.myValue);
        this.myRenderer.setEnabled(this.myEditIsAllowed);
        return this.myRenderer;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            if (this.myModel == null) {
                this.myModel = new SpinnerDateModel();
                this.myModel.addChangeListener(this);
            }
            this.myEditor = new JSpinner(this.myModel);
            this.myEditor.setEditor(this.getDateEditor());
        }
        this.myModel.setValue(this.myValue);
        this.myEditor.setEnabled(this.myEditIsAllowed);
        return this.myEditor;
    }

    protected JComponent getDateEditor() {
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.myEditor, this.getDateFormat()[0]);
        return editor;
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof Date) {
            this.myValue = (Date)v;
        } else if (v instanceof Calendar) {
            this.myValue = ((Calendar)v).getTime();
        } else {
            this.setVarValue(v.toString());
        }
        this.setEditorValue();
    }

    @Override
    protected void setVarValue(String v) {
        try {
            this.myValue = DateUtil.stringToDate(v, this.getDateFormat());
        }
        catch (ParseException x) {
            throw new RuntimeException(x);
        }
        this.setEditorValue();
    }

    protected void setEditorValue() {
        if (this.myEditor != null) {
            this.myModel.setValue(this.myValue);
        }
    }

    @Override
    public String toString() {
        return DateUtil.format(this.myValue);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.myValue = this.myModel.getDate();
        if (this.myDataItem != null) {
            this.myModel.removeChangeListener(this);
            this.myDataItem.setDataItem(this.getKey(), this);
            this.myModel.addChangeListener(this);
        }
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    protected void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public void editFinished() {
        try {
            if (this.myModel != null) {
                this.myModel.removeChangeListener(this);
            }
            if (this.myEditor != null) {
                this.myEditor.commitEdit();
            } else {
                if (this.myValue == null) {
                    this.myValue = new Date();
                }
                ((JSpinner)this.getEditor()).commitEdit();
            }
        }
        catch (ParseException e) {
            ExceptionUtil.handleException(e, "ratingRuleFrame");
        }
        if (this.myModel != null) {
            this.myValue = this.myModel.getDate();
        }
        if (this.myDataItem != null) {
            this.myDataItem.setDataItem(this.getKey(), this);
        }
    }
}

