/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.documents.FloatsOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;

public class DoubleVariable
extends AbstractNumberStringVariable {
    protected double myMinValue;
    protected double myMaxValue;
    protected boolean allowEmpty;

    public DoubleVariable(String label, String value) {
        this(label, value, false);
    }

    public DoubleVariable(String label, String value, boolean allowEmpty) {
        super(label, value);
        this.myMinValue = Double.NEGATIVE_INFINITY;
        this.myMaxValue = Double.POSITIVE_INFINITY;
        this.allowEmpty = allowEmpty;
    }

    public DoubleVariable(String label, double value) {
        this(label, String.valueOf(value), false);
    }

    public DoubleVariable(String label, double value, boolean allowEmpty) {
        this(label, String.valueOf(value), allowEmpty);
    }

    public DoubleVariable(String label, double value, double min, double max) {
        this(label, String.valueOf(value), min, max, false);
    }

    public DoubleVariable(String label, String value, double min, double max) {
        this(label, value, min, max, false);
    }

    public DoubleVariable(String label, String value, double min, double max, boolean allowEmpty) {
        this(label, value, allowEmpty);
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public DoubleVariable(DoubleVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
        this.allowEmpty = v.allowEmpty;
    }

    @Override
    public Object clone() {
        return new DoubleVariable(this);
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.allowEmpty && StringUtil.isEmptyString(this.myValue)) {
            return "";
        }
        if (this.isValueValid(value)) {
            return Double.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "Double";
    }

    public Class<Double> getValueClass() {
        return Double.class;
    }

    @Override
    public int getFormat() {
        return 8;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new FloatsOnlyDocument(this.myMinValue, this.myMaxValue, this.allowEmpty);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = String.valueOf(v);
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }

    public RatingDecimalVariable createCompatibleRatingDecimalVariable() {
        RatingDecimal min = this.myMinValue == Double.NEGATIVE_INFINITY ? null : new RatingDecimal(Double.toString(this.myMinValue));
        RatingDecimal max = this.myMaxValue == Double.POSITIVE_INFINITY ? null : new RatingDecimal(Double.toString(this.myMaxValue));
        RatingDecimalVariable rdVar = new RatingDecimalVariable(this.getLabel(), this.myValue, min, max, this.allowEmpty);
        rdVar.setKey(this.getKey());
        return rdVar;
    }
}

