/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.ItemEditHandler;
import ericsson.vareditor.variable.ItemEditorPanel;
import ericsson.vareditor.variable.ItemListModel;
import ericsson.vareditor.variable.ItemModel;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ItemListEditor
extends AbstractPanelVariableEditor
implements ActionListener {
    private static final long serialVersionUID = 6800227076650424994L;
    private JList myList;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myDeleteButton;
    private final ItemEditHandler myHandler;

    ItemListEditor(ItemListModel model, ItemEditHandler handler) {
        super(new BorderLayout());
        this.myHandler = handler;
        this.initPanel(model);
    }

    @Override
    public Component getEditorComponent(Variable variable) {
        ItemListModel model = (ItemListModel)variable.getModel();
        this.myList.setModel(model);
        return super.getEditorComponent(variable);
    }

    @Override
    public boolean isEditorValueValid() {
        boolean isValid = ((ItemListModel)this.myList.getModel()).isValid();
        LineBorder border = isValid ? null : new LineBorder(Color.RED);
        this.myList.setBorder(border);
        return isValid;
    }

    @Override
    public Object getEditorValue() {
        return this.myList.getModel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedIndex;
        Object source = e.getSource();
        if (source == this.myAddButton) {
            ItemEditorPanel panel = this.myHandler.createEditorPanel();
            EditDialog dialog = new EditDialog("Add...", panel);
            dialog.setSize(dialog.getPreferredSize());
            dialog.setVisible(true);
            if (dialog.okWasPressed()) {
                ((ItemListModel)this.myList.getModel()).add(panel.getModel());
            }
        } else if (source == this.myEditButton) {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue != null) {
                ItemEditorPanel panel = this.myHandler.createEditorPanel((ItemModel)selectedValue);
                EditDialog dialog = new EditDialog("Edit...", panel);
                dialog.setSize(dialog.getPreferredSize());
                dialog.setVisible(true);
                if (dialog.okWasPressed()) {
                    ItemListModel model = (ItemListModel)this.myList.getModel();
                    model.set(this.myList.getSelectedIndex(), panel.getModel());
                }
            }
        } else if (source == this.myDeleteButton && (selectedIndex = this.myList.getSelectedIndex()) >= 0) {
            ((ItemListModel)this.myList.getModel()).remove(selectedIndex);
        }
    }

    @Override
    public void setKeyListenerOnComponents(KeyListener k) {
        this.myList.addKeyListener(k);
        this.myAddButton.addKeyListener(k);
        this.myEditButton.addKeyListener(k);
        this.myDeleteButton.addKeyListener(k);
    }

    public void setModel(ItemListModel model) {
        this.myList.setModel(model);
    }

    private void initPanel(ItemListModel model) {
        this.myList = new JList(model);
        this.myList.getModel().addListDataListener(new ListListener());
        this.myList.setVisibleRowCount(5);
        this.myList.setName("ItemListEditor.JList.itemList");
        this.myList.setCellRenderer(new ItemRenderer());
        this.add((Component)new JScrollPane(this.myList), "Center");
        this.add(this.createButtonPanel(), "South");
        this.isEditorValueValid();
    }

    private Component createButtonPanel() {
        this.myAddButton = new JButton("Add");
        this.myAddButton.addActionListener(this);
        this.myAddButton.setName("ItemListEditor.JButton.add");
        this.myAddButton.setIcon(RmaDefs.getImageIcon("add2.png"));
        this.myAddButton.setMargin(new Insets(2, 2, 2, 2));
        this.myEditButton = new JButton("Edit");
        this.myEditButton.addActionListener(this);
        this.myEditButton.setName("ItemListEditor.JButton.edit");
        this.myEditButton.setIcon(RmaDefs.getImageIcon("new_edit.gif"));
        this.myEditButton.setMargin(new Insets(2, 2, 2, 2));
        this.myDeleteButton = new JButton("Delete");
        this.myDeleteButton.addActionListener(this);
        this.myDeleteButton.setName("ItemListEditor.JButton.delete");
        this.myDeleteButton.setIcon(RmaDefs.getImageIcon("new_delete.gif"));
        this.myDeleteButton.setMargin(new Insets(2, 2, 2, 2));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.myAddButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        panel.add((Component)this.myEditButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        panel.add((Component)this.myDeleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        return panel;
    }

    private class ItemRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -3096583540391961264L;

        private ItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel itemLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ItemModel itemModel = (ItemModel)value;
            itemLabel.setText(itemModel.describe());
            if (!itemModel.isValid()) {
                itemLabel.setBackground(Color.RED);
            }
            return itemLabel;
        }
    }

    private final class EditDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 6633048340506061610L;
        private JButton myOkButton;
        private JButton myCancelButton;
        private boolean myOkWasPressed;
        private ItemModel myModel;

        private EditDialog(String title, ItemEditorPanel content) {
            super(GuiUtil.getClosestWindowParent(ItemListEditor.this), title, Dialog.ModalityType.APPLICATION_MODAL);
            this.myModel = content.getModel();
            this.setName("ItemListEditor.JDialog.editDialog");
            this.setLocationRelativeTo(ItemListEditor.this);
            this.setLayout(new BorderLayout());
            this.add((Component)content, "Center");
            this.add(this.createDialogButtonPanel(), "South");
            this.pack();
        }

        private Component createDialogButtonPanel() {
            this.myOkButton = new JButton("Ok");
            this.myOkButton.addActionListener(this);
            this.myCancelButton = new JButton("Cancel");
            this.myCancelButton.addActionListener(this);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
            panel.add((Component)this.myOkButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
            panel.add((Component)this.myCancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.myOkButton) {
                if (this.myModel.isValid()) {
                    this.myOkWasPressed = true;
                    this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(this, "Input data is not valid", "Invalid input", 0);
                }
            } else {
                this.setVisible(false);
            }
        }

        private boolean okWasPressed() {
            return this.myOkWasPressed;
        }
    }

    private final class ListListener
    implements ListDataListener {
        private ListListener() {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ItemListEditor.this.fireDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ItemListEditor.this.fireDataChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ItemListEditor.this.fireDataChanged();
        }
    }
}

