/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.ItemEditHandler;
import ericsson.vareditor.variable.ItemListEditor;
import ericsson.vareditor.variable.ItemListModel;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;

public class ItemListVariable
extends PanelVariable {
    private final ItemEditHandler myHandler;

    public ItemListVariable(String label, ItemListModel value, ItemEditHandler handler) {
        super(label, ItemListVariable.checkValueNotNull(value));
        this.myHandler = this.checkHandler(handler);
    }

    private ItemListVariable(ItemListVariable v) {
        super(v);
        this.myHandler = v.myHandler;
        this.myValue = v.getModel().clone();
    }

    @Override
    public ItemListVariable clone() {
        return new ItemListVariable(this);
    }

    @Override
    public ItemListModel getModel() {
        return (ItemListModel)this.getValueObject();
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new ItemListEditor(this.getModel(), this.myHandler);
    }

    @Override
    protected void validate() {
        this.myIsValid = this.getModel().isValid();
    }

    @Override
    protected void setVarValue(Object v) {
        super.setVarValue(this.checkValue(v));
    }

    @Override
    protected void setVarValue(String v) {
        throw new UnsupportedOperationException("Setting valus as string is not supported");
    }

    @Override
    public String getValueString() {
        return this.getModel().describe();
    }

    @Override
    protected void setEditorValue() {
        ItemListEditor editor = (ItemListEditor)this.getPanelVariableEditor();
        editor.setModel(this.getModel());
    }

    private ItemListModel checkValue(Object value) {
        if (!(value instanceof ItemListModel)) {
            throw new IllegalArgumentException("Value must be an ItemListModel");
        }
        return (ItemListModel)value;
    }

    private ItemEditHandler checkHandler(ItemEditHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        return handler;
    }

    private static ItemListModel checkValueNotNull(ItemListModel value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        return value;
    }
}

