/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.datatype.MultiplierNumber;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.components.MultiplerSelectEditorPanel;
import ericsson.vareditor.components.SelectableMultipler;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import java.awt.Component;
import java.io.PrintWriter;
import javax.swing.JLabel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiplierSelectEditorVariable2
extends BaseVariable {
    private MultiplierSelectEditorVariable myWrappedVariable;
    private JLabel myRenderer;

    protected MultiplierSelectEditorVariable2(MultiplierSelectEditorVariable wrapped) {
        super(wrapped.getLabel());
        this.setKey(wrapped.getKey());
        this.myWrappedVariable = wrapped;
        DataItem old = this.myWrappedVariable.myDataItem;
        this.myWrappedVariable.setDataItem(new DataItemDispatcher());
        this.setDataItem(old);
    }

    public static MultiplierSelectEditorVariable2 wrap(MultiplierSelectEditorVariable inner) {
        int format = inner.getFormat();
        if (format != 5 && format != 8 && format != 7) {
            throw new IllegalArgumentException("Unknown variable format: " + inner.getFormat());
        }
        return new MultiplierSelectEditorVariable2(inner);
    }

    public static MultiplierSelectEditorVariable2 create(String label, MultiplierNumber value, SelectableMultipler[] multipliers, DataType dataType) {
        return MultiplierSelectEditorVariable2.create(label, value, multipliers, dataType, false, null, null);
    }

    public static MultiplierSelectEditorVariable2 create(String label, MultiplierNumber value, SelectableMultipler[] multipliers, DataType dataType, boolean allowEmpty) {
        return MultiplierSelectEditorVariable2.create(label, value, multipliers, dataType, allowEmpty, null, null);
    }

    public static MultiplierSelectEditorVariable2 create(String label, MultiplierNumber value, SelectableMultipler[] multipliers, DataType dataType, boolean allowEmpty, Number min, Number max) {
        if (value == null || multipliers == null || dataType == null || label == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        if (multipliers.length == 0) {
            throw new IllegalArgumentException("Zero-length multiplier list not permitted.");
        }
        if (dataType != DataType.INTEGER && dataType != DataType.DOUBLE && dataType != DataType.LONG) {
            throw new IllegalArgumentException("Unsupported data type: " + dataType);
        }
        RatingDecimal valueNumber = value.getValue();
        String innerValue = value.hasFloatingPointValue() ? valueNumber.toString() : Long.toString(valueNumber.longValue());
        String innerMultiplier = Long.toString(value.getMultiplier());
        int innerDataType = dataType == DataType.INTEGER ? 5 : (dataType == DataType.DOUBLE ? 8 : 7);
        MultiplierSelectEditorVariable inner = new MultiplierSelectEditorVariable(label, innerValue, innerMultiplier, multipliers, innerDataType, allowEmpty, min, max);
        return MultiplierSelectEditorVariable2.wrap(inner);
    }

    @Override
    public Object clone() {
        MultiplierSelectEditorVariable copy = (MultiplierSelectEditorVariable)this.myWrappedVariable.clone();
        copy.setLabel(this.myWrappedVariable.getLabel());
        copy.setKey(this.myWrappedVariable.getKey());
        return new MultiplierSelectEditorVariable2(copy);
    }

    @Override
    public Component getEditor() {
        return this.myWrappedVariable.getEditor();
    }

    @Override
    public int getFormat() {
        return this.myWrappedVariable.getFormat();
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new JLabel();
        }
        this.myRenderer.setText(this.toString());
        return this.myRenderer;
    }

    @Override
    public String getTypename() {
        return this.myWrappedVariable.getTypename();
    }

    @Override
    public Class<?> getValueClass() {
        return MultiplierNumber.class;
    }

    @Override
    public String getValueString() {
        Object value = this.myWrappedVariable.getValueObject();
        if (value == null) {
            return null;
        }
        String strValue = value.toString();
        String multiplierString = this.myWrappedVariable.getSelectedFactorFromSuffix();
        SelectableMultipler found = this.findMultiplier(multiplierString, true);
        if (found == null) {
            return null;
        }
        String lbl = found.getLabel();
        return lbl.isEmpty() ? strValue : strValue + " " + lbl;
    }

    @Override
    public Object getValueObject() {
        Object value = this.myWrappedVariable.getValueObject();
        if (value == null) {
            return null;
        }
        RatingDecimal rd = new RatingDecimal(value.toString());
        String multiplierString = this.myWrappedVariable.getSelectedFactorFromSuffix();
        SelectableMultipler found = this.findMultiplier(multiplierString, true);
        if (found == null) {
            return null;
        }
        return new MultiplierNumber(rd, (long)found.getMultiplier());
    }

    private SelectableMultipler findMultiplier(String multiplierString, boolean isNumeric) {
        boolean checkLabels = !isNumeric;
        long multiplierValue = Long.MIN_VALUE;
        if (isNumeric) {
            multiplierValue = Long.parseLong(multiplierString);
        }
        SelectableMultipler[] multipliers = this.myWrappedVariable.mySelections;
        SelectableMultipler found = null;
        for (SelectableMultipler sm : multipliers) {
            boolean match = false;
            if (checkLabels) {
                match = multiplierString.equalsIgnoreCase(sm.getLabel());
            } else {
                boolean bl = match = multiplierValue == sm.getMultiplier();
            }
            if (!match) continue;
            found = sm;
            break;
        }
        return found;
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        throw new UnsupportedOperationException("XML reading/writing not supported.");
    }

    @Override
    public boolean isValueValid() {
        return this.myWrappedVariable.isValueValid();
    }

    @Override
    protected void setVarValue(Object v) {
        if (!(v instanceof MultiplierNumber)) {
            throw new IllegalArgumentException("Unknown value object type: " + v);
        }
        MultiplierNumber vo = (MultiplierNumber)v;
        String multiplierString = String.valueOf(vo.getMultiplier());
        SelectableMultipler found = this.findMultiplier(multiplierString, true);
        if (found == null) {
            throw new IllegalArgumentException("Failed to identify multiplier based on factor: " + multiplierString);
        }
        RatingDecimal rd = vo.getValue();
        String str = this.isInteger(rd) ? Integer.toString(rd.intValue()) : rd.toString();
        this.initWrappedVariableWithXML(str, found);
        this.updateRendererIfCreated();
    }

    private boolean isInteger(RatingDecimal rd) {
        return rd.equals(new RatingDecimal(rd.intValue(), 1L));
    }

    private void updateRendererIfCreated() {
        if (this.myRenderer == null) {
            return;
        }
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                MultiplierSelectEditorVariable2.this.getRenderer();
            }
        });
    }

    @Override
    protected void setVarValue(String v) {
        String multiplierString;
        String strValue;
        int idxSpace = v.indexOf(32);
        if (idxSpace < 0) {
            strValue = v;
            multiplierString = "";
        } else {
            strValue = v.substring(0, idxSpace);
            multiplierString = v.substring(idxSpace + 1);
        }
        SelectableMultipler found = this.findMultiplier(multiplierString, this.isLongNumeric(multiplierString));
        if (found == null) {
            throw new IllegalArgumentException("Failed to identify multiplier based on factor: " + multiplierString);
        }
        this.initWrappedVariableWithXML(strValue, found);
        this.updateRendererIfCreated();
    }

    private void initWrappedVariableWithXML(String value, SelectableMultipler multiplier) {
        Document doc = XMLUtil.createEmptyDocument();
        Element e = doc.createElement("Temp");
        Element factor = doc.createElement(MultiplerSelectEditorPanel.TAG_UNIT_FACTOR);
        factor.setTextContent(Long.toString(multiplier.getMultiplier()));
        e.appendChild(factor);
        this.myWrappedVariable.initFromXml(e, value, this.myWrappedVariable.getKey(), this.myWrappedVariable.getFormat());
    }

    private boolean isLongNumeric(String str) {
        boolean multiplierIsNumeric;
        try {
            Long.parseLong(str);
            multiplierIsNumeric = true;
        }
        catch (NumberFormatException e) {
            multiplierIsNumeric = false;
        }
        return multiplierIsNumeric;
    }

    @Override
    protected void writeXMLVarSpecific(PrintWriter out) {
        throw new UnsupportedOperationException("XML reading/writing not supported.");
    }

    @Override
    public String toString() {
        return this.getValueString();
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myWrappedVariable.editorHasBeenCreated();
    }

    private class DataItemDispatcher
    extends DataItemAdapter {
        private DataItemDispatcher() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            MultiplierSelectEditorVariable2.this.updateRendererIfCreated();
            MultiplierSelectEditorVariable2.this.fireValueChanged();
        }
    }
}

