/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.EreDefs;
import ericsson.vareditor.documents.AllNumbersDocument;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.RangeObject;
import ericsson.vareditor.variable.RangeVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class RangeVariablePanel
extends AbstractPanelVariableEditor
implements DocumentListener,
FocusListener {
    private RangeVariable myVariable = null;
    private DataType myDataType;
    private static String[][] myLimitArray = new String[][]{{Long.toString(0L), Long.toString(0xFFFFFFFFL)}, {Long.toString(0L), Long.toString(65535L)}, {Long.toString(0L), Long.toString(255L)}, {"", ""}, {Double.toString(Double.NEGATIVE_INFINITY), Double.toString(Double.POSITIVE_INFINITY)}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {Short.toString((short)Short.MIN_VALUE), Short.toString((short)Short.MAX_VALUE)}, {Integer.toString(Integer.MIN_VALUE), Integer.toString(Integer.MAX_VALUE)}, {Long.toString(Long.MIN_VALUE), Long.toString(Long.MAX_VALUE)}, {Double.toString(Double.MIN_VALUE), Double.toString(Double.MAX_VALUE)}, {"", ""}, {"", ""}, {"0", "65535"}, {"0", "4294967295"}, {"0", "18446744073709551615"}, {"", ""}, {"", ""}, {"0", "0"}};
    private static final int MIN = 0;
    private static final int MAX = 1;
    private String myMaxStartValue;
    private String myMinStartValue;
    private JPanel myPanel;
    private final JLabel LABEL_MIN = new JLabel("Min ");
    private final JLabel LABEL_MAX = new JLabel("Max ");
    private JTextField myMinTextField = new JTextField();
    private JTextField myMaxTextField = new JTextField();
    private JLabel myMinLabel;
    private JLabel myMaxLabel;
    private PlainDocument myMinDocument;
    private PlainDocument myMaxDocument;
    private JCheckBox myMinCheckBox = new JCheckBox();
    private JCheckBox myMaxCheckBox = new JCheckBox();
    private boolean myMinIsValid = true;
    private boolean myMaxIsValid = true;
    private boolean myShowCheckBoxes = false;

    public RangeVariablePanel(RangeVariable aVar, DataType dataType, boolean showCheckBoxes) {
        this.myVariable = aVar;
        this.myDataType = dataType;
        this.myShowCheckBoxes = showCheckBoxes;
        this.init(null, null);
        this.buildPanel();
    }

    public RangeVariablePanel(RangeVariable aVar, DataType dataType, String minValue, String maxValue, boolean showCheckBoxes) {
        this.myVariable = aVar;
        this.myDataType = dataType;
        this.myShowCheckBoxes = showCheckBoxes;
        this.init(minValue, maxValue);
        this.buildPanel();
    }

    private void init(String startMinValue, String startMaxValue) {
        if (this.myDataType == DataType.DECIMAL) {
            this.myShowCheckBoxes = false;
        }
        this.myMinStartValue = startMinValue == null ? myLimitArray[this.myDataType.getTypeIdentifier()][0] : startMinValue;
        this.myMaxStartValue = startMaxValue == null ? myLimitArray[this.myDataType.getTypeIdentifier()][1] : startMaxValue;
        this.myMinDocument = new AllNumbersDocument(this.myDataType);
        this.myMaxDocument = new AllNumbersDocument(this.myDataType);
        this.myMinLabel = new JLabel(myLimitArray[this.myDataType.getTypeIdentifier()][0]);
        this.myMinLabel.setHorizontalAlignment(4);
        this.myMinLabel.setBorder(new EtchedBorder(1));
        this.myMaxLabel = new JLabel(myLimitArray[this.myDataType.getTypeIdentifier()][1]);
        this.myMaxLabel.setHorizontalAlignment(4);
        this.myMaxLabel.setBorder(new EtchedBorder(1));
        this.myMinTextField.setHorizontalAlignment(4);
        this.myMaxTextField.setHorizontalAlignment(4);
        this.myMinTextField.setDocument(this.myMinDocument);
        this.myMaxTextField.setDocument(this.myMaxDocument);
        this.myMinTextField.addFocusListener(this);
        this.myMaxTextField.addFocusListener(this);
        this.myMinTextField.setText(this.myMinStartValue);
        this.myMaxTextField.setText(this.myMaxStartValue);
        this.myMaxDocument.addDocumentListener(this);
        this.myMinDocument.addDocumentListener(this);
        this.myMinCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (RangeVariablePanel.this.myMinCheckBox.isSelected()) {
                    RangeVariablePanel.this.myPanel.remove(RangeVariablePanel.this.myMinTextField);
                    RangeVariablePanel.this.myMinTextField.setText(myLimitArray[RangeVariablePanel.this.myDataType.getTypeIdentifier()][0]);
                    RangeVariablePanel.this.myPanel.add((Component)RangeVariablePanel.this.myMinLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    RangeVariablePanel.this.myPanel.remove(RangeVariablePanel.this.myMinLabel);
                    RangeVariablePanel.this.myPanel.add((Component)RangeVariablePanel.this.myMinTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                }
                RangeVariablePanel.this.myPanel.validate();
                RangeVariablePanel.this.myPanel.repaint();
                RangeVariablePanel.this.focusLost(null);
            }
        });
        this.myMaxCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (RangeVariablePanel.this.myMaxCheckBox.isSelected()) {
                    RangeVariablePanel.this.myPanel.remove(RangeVariablePanel.this.myMaxTextField);
                    RangeVariablePanel.this.myMaxTextField.setText(myLimitArray[RangeVariablePanel.this.myDataType.getTypeIdentifier()][1]);
                    RangeVariablePanel.this.myPanel.add((Component)RangeVariablePanel.this.myMaxLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    RangeVariablePanel.this.myPanel.remove(RangeVariablePanel.this.myMaxLabel);
                    RangeVariablePanel.this.myPanel.add((Component)RangeVariablePanel.this.myMaxTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                }
                RangeVariablePanel.this.myPanel.validate();
                RangeVariablePanel.this.myPanel.repaint();
                RangeVariablePanel.this.focusLost(null);
            }
        });
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.add((Component)this.LABEL_MIN, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myShowCheckBoxes) {
            this.myPanel.add((Component)this.myMinCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myPanel.add((Component)this.myMinTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)this.LABEL_MAX, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myShowCheckBoxes) {
            this.myPanel.add((Component)this.myMaxCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myPanel.add((Component)this.myMaxTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 5, 2, 0), 0, 0));
    }

    public String getMinValue() {
        return this.myMinTextField.getText();
    }

    public String getMaxValue() {
        return this.myMaxTextField.getText();
    }

    @Override
    public Object getEditorValue() {
        try {
            Object minVal = this.myDataType.parseValue(this.myMinTextField.getText());
            Object maxVal = this.myDataType.parseValue(this.myMaxTextField.getText());
            return RangeVariablePanel.createRangeObject(this.myDataType, minVal.toString(), maxVal.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isEditorValueValid() {
        return this.validateFields();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateFields();
        this.myVariable.setEditorChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateFields();
        this.myVariable.setEditorChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateFields();
        this.myVariable.setEditorChanged();
    }

    private boolean validateFields() {
        BigInteger maxValue;
        BigInteger minValue;
        this.myMinIsValid = ((FieldValidation)((Object)this.myMinDocument)).isValid(this.myMinTextField.getText());
        this.myMaxIsValid = ((FieldValidation)((Object)this.myMaxDocument)).isValid(this.myMaxTextField.getText());
        boolean isValid = false;
        isValid = this.myMinIsValid && this.myMaxIsValid ? (this.myDataType.isIntegerNumeric() ? (minValue = new BigInteger(this.myMinTextField.getText())).compareTo(maxValue = new BigInteger(this.myMaxTextField.getText())) <= 0 : (this.myDataType == DataType.DECIMAL || this.myDataType == DataType.DOUBLE || this.myDataType == DataType.RATINGDECIMAL ? (minValue = new BigDecimal(this.myMinTextField.getText())).compareTo(maxValue = new BigDecimal(this.myMaxTextField.getText())) <= 0 : false)) : false;
        if (isValid) {
            this.myMinTextField.setBackground(Color.WHITE);
            this.myMaxTextField.setBackground(Color.WHITE);
            return true;
        }
        if (!this.myMinTextField.hasFocus()) {
            this.myMaxTextField.setBackground(Color.RED);
        }
        if (!this.myMaxTextField.hasFocus()) {
            this.myMinTextField.setBackground(Color.RED);
        }
        this.myMinIsValid = false;
        this.myMaxIsValid = false;
        return false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource().equals(this.myMinTextField)) {
            this.myMinTextField.setBackground(Color.WHITE);
        } else {
            this.myMaxTextField.setBackground(Color.WHITE);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateTextFieldsBackground();
    }

    private void updateTextFieldsBackground() {
        if (!this.myMinIsValid || !this.myMaxIsValid) {
            this.myMinTextField.setBackground(Color.RED);
            this.myMaxTextField.setBackground(Color.RED);
        } else {
            this.myMinTextField.setBackground(Color.WHITE);
            this.myMaxTextField.setBackground(Color.WHITE);
        }
    }

    public void setAllowEdit(boolean allow) {
        this.myMinCheckBox.setEnabled(allow);
        this.myMaxCheckBox.setEnabled(allow);
        this.myMinTextField.setEnabled(allow);
        this.myMaxTextField.setEnabled(allow);
    }

    public static boolean isDataTypeSupported(String dateTypeString) {
        switch (EreDefs.getDataType(dateTypeString)) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public void setEditorValue(String minValue, String maxValue) {
        this.myMinTextField.setText(minValue);
        this.myMaxTextField.setText(maxValue);
    }

    protected static RangeObject createDefaultRangeObject(DataType dataType) {
        return new RangeObject(dataType.isIntegerNumeric(), myLimitArray[dataType.getTypeIdentifier()][0], myLimitArray[dataType.getTypeIdentifier()][1]);
    }

    protected static RangeObject createRangeObject(DataType dataType, String minValue, String maxValue) {
        return new RangeObject(dataType.isIntegerNumeric(), minValue, maxValue);
    }
}

