/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.datatype.LazyEvaluatedERETime;
import com.ericsson.ere.gui.util.RelativeTimePanel;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.RelativeDateVariable;
import java.util.ArrayList;

public class RelativeDateTimeVariable
extends RelativeDateVariable {
    public RelativeDateTimeVariable(String label, String constraintIdentity, FieldDefinition field) {
        super(label, constraintIdentity, field);
    }

    public RelativeDateTimeVariable(String label, String constraintIdentity, String value, FieldDefinition field) {
        super(label, constraintIdentity, value, field);
    }

    @Override
    public Object clone() {
        return new RelativeDateTimeVariable(this);
    }

    private RelativeDateTimeVariable(RelativeDateTimeVariable aVar) {
        super(aVar.myLabel, aVar.myConstraintId, aVar.myField);
        this.myValue = aVar.myValue;
        this.myFields = new ArrayList(aVar.myFields);
        this.myClassRepository = aVar.myClassRepository;
    }

    @Override
    public Object getValueObject() {
        return new LazyEvaluatedERETime((String)this.myValue);
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof LazyEvaluatedERETime) {
            this.myValue = ((LazyEvaluatedERETime)v).getExpressionString();
            this.validate();
        } else if (v instanceof ERETime) {
            this.myValue = ERETimeUtil.makeISOStringFromERETime((ERETime)v) + "F";
            this.validate();
        } else {
            this.setVarValue(v.toString());
        }
    }

    @Override
    protected void setVarValue(String v) {
        try {
            ERETime time = ERETimeFactory.parseTimeString(v);
            this.myValue = ERETimeUtil.makeISOStringFromERETime(time) + "F";
        }
        catch (Exception e) {
            this.myValue = v;
        }
        this.validate();
    }

    @Override
    protected void setValidIndication(String message) {
        RelativeTimePanel panel = (RelativeTimePanel)this.myPanelVariableEditor;
        if (this.editorHasBeenCreated()) {
            panel.setEditorBackground(this.myIsValid);
            if (message != null) {
                panel.setTextIndication(message);
            }
        }
    }

    @Override
    public boolean isAllowed(FieldDefinition field) {
        boolean result = true;
        if (!field.getTypedDataType().equals(DataType.TIME)) {
            result = false;
        }
        if (!field.isFieldOriented() || "WORKING".equals(field.getParameterType())) {
            result = false;
        }
        return result;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new RelativeTimePanel((String)this.myValue, this.myFields, this.myClassRepository, this.myField);
    }
}

