/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.LazyEvaluatedEREDate;
import com.ericsson.ere.expression.parser.DefaultExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.RelativeDatePanel;
import com.ericsson.ere.interfaces.LocationDependent;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.util.Location;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.variable.ClassRepositoryUser;
import ericsson.vareditor.variable.ConstrainableVariable;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RelativeDateVariable
extends PanelVariable
implements ConstrainableVariable,
ClassRepositoryUser,
FieldFilter,
LocationDependent {
    protected List<FieldDefinition> myFields;
    protected String myConstraintId;
    protected ClassRepository myClassRepository;
    protected FieldDefinition myField;

    @Deprecated
    public RelativeDateVariable(String label, FieldDefinition aTargetFieldDef) {
        this(label, aTargetFieldDef, "");
    }

    @Deprecated
    public RelativeDateVariable(RelativeDateVariable aVar) {
        this(aVar, 0);
    }

    @Deprecated
    public RelativeDateVariable(String label, FieldDefinition aTargetFieldDef, String value) {
        super(label);
        this.myValue = value;
    }

    public RelativeDateVariable(String label, String constraintIdentity, FieldDefinition field) {
        this(label, constraintIdentity, "", field);
    }

    public RelativeDateVariable(String label, String constraintIdentity, String value, FieldDefinition field) {
        super(label);
        this.myConstraintId = constraintIdentity;
        this.myValue = value;
        this.myField = field;
    }

    private RelativeDateVariable(RelativeDateVariable aVar, int dummy) {
        super(aVar);
        this.myValue = aVar.myValue;
        this.myFields = new ArrayList<FieldDefinition>(aVar.myFields);
        this.myConstraintId = aVar.myConstraintId;
        this.myClassRepository = aVar.myClassRepository;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new RelativeDatePanel((String)this.myValue, this.myFields, this.myClassRepository, this.myField);
    }

    @Override
    protected void validate() {
        try {
            ExpressionParser theParser = new ExpressionParser(new DefaultExpressionParserOptions(), new DefaultExpressionParserHandler(this.myClassRepository, null, null));
            theParser.parse(this.myValue.toString());
            this.myIsValid = true;
            this.setValidIndication(null);
        }
        catch (Exception e) {
            this.myIsValid = false;
            this.setValidIndication(e.getMessage());
            ExceptionUtil.handleException(e, "service", 2, "Failed to parse expression string", false);
        }
    }

    protected void setValidIndication(String message) {
        if (this.editorHasBeenCreated()) {
            ((RelativeDatePanel)this.myPanelVariableEditor).setEditorBackground(this.myIsValid);
            if (message != null) {
                ((RelativeDatePanel)this.myPanelVariableEditor).setTextIndication(message);
            }
        }
    }

    @Override
    public Object getValueObject() {
        return new LazyEvaluatedEREDate((String)this.myValue);
    }

    @Override
    public String getValueString() {
        return (String)this.myValue;
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof LazyEvaluatedEREDate) {
            super.setVarValue(((LazyEvaluatedEREDate)v).getExpressionString());
        } else if (v instanceof EREDate) {
            EREDate date = (EREDate)v;
            String str = String.format("%04d%02d%02dT000000000O", date.getFullYear(), date.getMonthOfYear(), date.getDayOfMonth());
            super.setVarValue(str);
        } else {
            try {
                DateUtil.parse(v.toString());
                super.setVarValue(v.toString() + 'O');
            }
            catch (Exception e) {
                super.setVarValue(v);
            }
        }
        this.validate();
    }

    @Override
    protected void setVarValue(String v) {
        String str = v;
        try {
            DateUtil.parse(str);
            str = str + "O";
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setVarValue(str);
        this.validate();
    }

    @Override
    public Object clone() {
        return new RelativeDateVariable(this, 0);
    }

    @Override
    public void constrainApplicableFields(Constrainable constrainable, ClassRepository repository, List<FieldDefinition> candidateFields) {
        List<FieldDefinition> theList = FieldOrientedPluginProfileUtil.getSupportedFields(candidateFields, this);
        if (this.myConstraintId != null) {
            ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.IDENTITY, this.myConstraintId).build();
            this.myFields = ConstraintService.constrainFieldDefinitions(constrainable, context, repository, theList);
        } else {
            this.myFields = theList;
        }
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        this.myClassRepository = rep;
        if (this.myClassRepository != null) {
            this.myFields = FieldOrientedPluginProfileUtil.getSupportedFields(this.myClassRepository.getFieldDefinitions(), this);
        }
    }

    @Override
    public Class<?> getValueClass() {
        return Date.class;
    }

    @Override
    public boolean isAllowed(FieldDefinition field) {
        if (!field.getTypedDataType().equals(DataType.DATE) && !field.getTypedDataType().equals(DataType.TIME)) {
            return false;
        }
        if (field.isSet()) {
            return false;
        }
        return field.isFieldOriented() && !"WORKING".equals(field.getParameterType());
    }

    @Override
    public Location[] appliesTo() {
        return new Location[]{Location.SELECTION_TREE};
    }

    @Override
    public boolean isApplicableIn(Location location) {
        return location == Location.SELECTION_TREE;
    }

    @Override
    public void dataChanged() {
        this.myValue = this.myPanelVariableEditor.getEditorValue();
        this.validate();
        this.fireValueChanged();
    }

    @Override
    public String toString() {
        String expressionString = ExpressionParser.convertExpressionToDisplayableString(this.myValue.toString(), this.myClassRepository);
        expressionString = ExpressionParser.replaceDateConstants(this.myField, expressionString);
        return expressionString;
    }
}

