/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.gui.log.logtable.NumberListTableModel;
import ericsson.vareditor.variable.TableVariableException;
import ericsson.vareditor.variable.validator.TableVariableValidator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class TableVariableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    private TableVariableValidator myValidator;
    private JTextField myInputField;
    private NumberListTableModel myModel;
    private String myValue;
    private boolean myEnterAction = false;

    public TableVariableCellEditor(NumberListTableModel model) {
        super(new JTextField());
        this.myModel = model;
        this.myValidator = this.myModel.getValidator();
        this.myInputField = (JTextField)this.getComponent();
        this.myInputField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.myInputField.getActionMap().put("check", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TableVariableCellEditor.this.myEnterAction = true;
                TableVariableCellEditor.this.myInputField.postActionEvent();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JTextField inputField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.myValue = (String)value;
        return inputField;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopCellEditing() {
        String get = this.myModel.getValueString();
        get = get.replace(this.myValue + ",", "");
        get = get.replace("," + this.myValue, "");
        if (this.myValue.equals(this.myInputField.getText())) return super.stopCellEditing();
        if (!this.myEnterAction) {
            int response = JOptionPane.showConfirmDialog(this.myInputField, "Commit changes?");
            if (response != 0) {
                this.myInputField.setText(this.myValue);
                return true;
            }
            if (!this.myValidator.isInputValid(this.myInputField.getText())) {
                if (this.userSaysRevert("Input is not valid")) return super.stopCellEditing();
                return false;
            }
            try {
                this.myValidator.isValueInModelWithInfo(this.myInputField.getText(), get);
                return super.stopCellEditing();
            }
            catch (TableVariableException e) {
                if (this.userSaysRevert(e.getMessage())) return super.stopCellEditing();
                return false;
            }
        }
        this.myEnterAction = false;
        if (!this.myValidator.isInputValid(this.myInputField.getText())) {
            if (this.userSaysRevert("Input is not valid")) return super.stopCellEditing();
            return false;
        }
        try {
            this.myValidator.isValueInModelWithInfo(this.myInputField.getText(), get);
            return super.stopCellEditing();
        }
        catch (TableVariableException e) {
            if (this.userSaysRevert(e.getMessage())) return super.stopCellEditing();
            return false;
        }
    }

    protected boolean userSaysRevert(String info) {
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(this.myInputField, info, "Invalid text entered", 0, 0, null, options, options[0]);
        if (answer == 1) {
            this.myInputField.setText(this.myValue);
            return true;
        }
        return false;
    }
}

