/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.BaseTypedDropDownVariable;
import ericsson.vareditor.variable.VariableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class TypedDropDownVariable<T>
extends BaseTypedDropDownVariable<T>
implements ActionListener {
    private T[] myItems;
    private int mySelectedIndex = -1;
    private JComboBox myEditor;
    private ItemLabeler<T> myItemLabeler;
    private T myExternallySelected;
    private boolean myDontFireValueChanged;

    private static <U> U firstItemOrNull(U[] items) {
        return items != null && items.length > 0 ? (U)items[0] : null;
    }

    public TypedDropDownVariable(String label, T[] items) {
        this(label, items, TypedDropDownVariable.firstItemOrNull(items), new ToStringLabeler());
    }

    public TypedDropDownVariable(String label, T[] items, T selected) {
        this(label, items, selected, new ToStringLabeler());
    }

    public TypedDropDownVariable(String label, String[] labels, T[] items) {
        this(label, labels, items, TypedDropDownVariable.firstItemOrNull(items));
    }

    public TypedDropDownVariable(String label, String[] labels, T[] items, T selected) {
        this(label, items, selected, new LabelListLabeler(labels));
        if (labels == null) {
            throw new IllegalArgumentException("Labels array cannot be null.");
        }
        if (labels.length != items.length) {
            throw new IllegalArgumentException("Must have as many labels as choices.");
        }
    }

    public TypedDropDownVariable(String label, T[] items, ItemLabeler<T> itemLabeler) {
        this(label, items, TypedDropDownVariable.firstItemOrNull(items), itemLabeler);
    }

    public TypedDropDownVariable(String label, T[] items, T selected, ItemLabeler<T> itemLabeler) {
        super(label);
        if (items == null) {
            throw new IllegalArgumentException("Items array cannot be null.");
        }
        this.myItems = Arrays.copyOf(items, items.length);
        this.myItemLabeler = itemLabeler;
        this.setSelectedItem(selected);
    }

    private String labelFor(int index) {
        if (index < 0) {
            if (this.myExternallySelected != null) {
                try {
                    return this.myItemLabeler.getDisplayStringFor(this.myExternallySelected, -1);
                }
                catch (IndexOutOfBoundsException e) {
                    return String.valueOf(this.myExternallySelected);
                }
            }
            return "";
        }
        return this.myItemLabeler.getDisplayStringFor(this.myItems[index], index);
    }

    private int indexOfLabel(String label) {
        int index = -1;
        for (int i = 0; label != null && i < this.myItems.length; ++i) {
            if (!label.equals(this.labelFor(i))) continue;
            index = i;
            break;
        }
        return index;
    }

    private int indexOf(T item) {
        int index = -1;
        for (int i = 0; item != null && i < this.myItems.length; ++i) {
            if (!item.equals(this.myItems[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    protected void fireValueChanged() {
        if (!this.myDontFireValueChanged) {
            super.fireValueChanged();
        }
    }

    @Override
    public Object clone() {
        T selected = this.mySelectedIndex >= 0 ? (T)this.myItems[this.mySelectedIndex] : null;
        TypedDropDownVariable<Object> var = new TypedDropDownVariable<Object>(this.getLabel(), this.myItems, selected, (ItemLabeler<Object>)this.myItemLabeler);
        var.setKey(this.getKey());
        return var;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new JComboBox(new DropDownModel());
            this.myEditor.setRenderer(VariableUtil.createDropDownRenderer(this, Color.red));
            this.myEditor.addActionListener(this);
        }
        this.myEditor.setEnabled(this.myEditIsAllowed);
        this.updateEditorBackground();
        return this.myEditor;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    @Override
    public String getValueString() {
        T vo = this.getSelectedItem();
        return this.labelFor(this.indexOf(vo));
    }

    @Override
    public boolean isValueValid() {
        return this.mySelectedIndex != -1;
    }

    @Override
    protected void setVarValue(Object v) {
        this.myDontFireValueChanged = true;
        try {
            this.setSelectedItem(v);
        }
        finally {
            this.myDontFireValueChanged = false;
        }
    }

    @Override
    protected void setVarValue(String v) {
        this.myDontFireValueChanged = true;
        try {
            this.setSelectedIndex(this.indexOfLabel(v));
        }
        finally {
            this.myDontFireValueChanged = false;
        }
    }

    @Override
    public void setSelectedItem(T v) {
        int index = this.indexOf(v);
        this.setSelectedIndex(index);
        if (index < 0) {
            this.myExternallySelected = v;
        }
    }

    public void setSelectedIndex(int index) {
        if (index >= 0) {
            this.myExternallySelected = null;
        }
        if (this.myEditor != null) {
            this.myEditor.setSelectedIndex(index);
        } else {
            this.mySelectedIndex = index;
        }
        this.fireValueChanged();
    }

    @Override
    public T getSelectedItem() {
        if (this.mySelectedIndex < 0) {
            return this.myExternallySelected;
        }
        return this.myItems[this.mySelectedIndex];
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireValueChanged();
        this.updateEditorBackground();
    }

    private void updateEditorBackground() {
        if (this.myEditor != null) {
            this.myEditor.setBackground(this.isValueValid() ? UIManager.getColor("ComboBox.background") : Color.RED);
        }
    }

    private static class ToStringLabeler<U>
    implements ItemLabeler<U> {
        private ToStringLabeler() {
        }

        @Override
        public String getDisplayStringFor(U object, int index) {
            return String.valueOf(object);
        }
    }

    private static class LabelListLabeler<U>
    implements ItemLabeler<U> {
        private String[] myLabels;

        private LabelListLabeler(String[] labels) {
            this.myLabels = labels;
        }

        @Override
        public String getDisplayStringFor(U object, int index) {
            return this.myLabels[index];
        }
    }

    public static interface ItemLabeler<U> {
        public String getDisplayStringFor(U var1, int var2);
    }

    private class DropDownModel
    extends AbstractListModel
    implements ComboBoxModel {
        private DropDownModel() {
        }

        @Override
        public Object getSelectedItem() {
            return TypedDropDownVariable.this.labelFor(TypedDropDownVariable.this.mySelectedIndex);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null) {
                TypedDropDownVariable.this.mySelectedIndex = -1;
            } else {
                TypedDropDownVariable.this.mySelectedIndex = TypedDropDownVariable.this.indexOfLabel(String.valueOf(anItem));
            }
            TypedDropDownVariable.this.myExternallySelected = null;
            TypedDropDownVariable.this.updateEditorBackground();
            this.fireContentsChanged(TypedDropDownVariable.this, TypedDropDownVariable.this.mySelectedIndex, TypedDropDownVariable.this.mySelectedIndex);
        }

        @Override
        public Object getElementAt(int index) {
            return TypedDropDownVariable.this.labelFor(index);
        }

        @Override
        public int getSize() {
            return TypedDropDownVariable.this.myItems.length;
        }
    }
}

