/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.documents.UnsignedNumberDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;
import java.awt.Color;
import java.math.BigInteger;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class UIntegerVariable
extends AbstractNumberStringVariable {
    protected BigInteger myMinValue;
    protected BigInteger myMaxValue;

    public UIntegerVariable(String label, BigInteger value) {
        super(label);
        this.myValue = UIntegerVariable.switchToUnsigned(String.valueOf(value));
        this.myMinValue = UnsignedNumberDocument.BIGINT_ZERO;
        this.myMaxValue = UnsignedNumberDocument.MAX_UINT;
    }

    public UIntegerVariable(String label, String value) {
        super(label, UIntegerVariable.switchToUnsigned(value));
        this.myMinValue = UnsignedNumberDocument.BIGINT_ZERO;
        this.myMaxValue = UnsignedNumberDocument.MAX_UINT;
    }

    public UIntegerVariable(String label, BigInteger value, BigInteger min, BigInteger max) {
        super(label);
        this.myValue = UIntegerVariable.switchToUnsigned(String.valueOf(value));
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public UIntegerVariable(String label, String value, BigInteger min, BigInteger max) {
        super(label, UIntegerVariable.switchToUnsigned(value));
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public UIntegerVariable(UIntegerVariable v) {
        super(v);
        this.myValue = UIntegerVariable.switchToUnsigned(v.myValue);
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
    }

    @Override
    public Object clone() {
        return new UIntegerVariable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(UIntegerVariable.switchToUnsigned(value))) {
            BigInteger bigInt = new BigInteger(value);
            return new Integer(bigInt.intValue());
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "UInteger";
    }

    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @Override
    public int getFormat() {
        return 13;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new UnsignedNumberDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = UIntegerVariable.switchToUnsigned(String.valueOf(v));
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = UIntegerVariable.switchToUnsigned(v);
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setEditorValue(String v) {
        if (this.myEditor != null) {
            boolean isValid;
            if (this.isValueValid(v)) {
                ((JTextComponent)this.myEditor).setDocument(this.myModel);
                isValid = true;
            } else {
                ((JTextComponent)this.myEditor).setDocument(new PlainDocument());
                isValid = false;
            }
            ((JTextComponent)this.myEditor).setBackground(isValid ? UIManager.getColor("TextField.background") : Color.RED);
            ((JTextComponent)this.myEditor).setText(v);
        } else {
            this.myValue = v;
        }
    }

    private static String switchToUnsigned(String value) {
        if (value.startsWith("-")) {
            return new BigInteger(Long.toBinaryString(Long.parseLong(value)).substring(32), 2).toString();
        }
        if (value.length() > 0) {
            return new BigInteger(value).toString();
        }
        return "";
    }

    public BigInteger getMinValue() {
        return this.myMinValue;
    }

    public BigInteger getMaxValue() {
        return this.myMaxValue;
    }

    @Override
    public String toString() {
        return this.myValue.toString();
    }
}

