/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.documents.UnsignedNumberDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;
import java.awt.Color;
import java.math.BigInteger;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class UShortVariable
extends AbstractNumberStringVariable {
    protected BigInteger myMinValue;
    protected BigInteger myMaxValue;

    public UShortVariable(String label, BigInteger value) {
        super(label);
        this.myValue = UShortVariable.switchToUnsigned(String.valueOf(value));
        this.myMinValue = UnsignedNumberDocument.BIGINT_ZERO;
        this.myMaxValue = UnsignedNumberDocument.MAX_USHORT;
    }

    public UShortVariable(String label, String value) {
        super(label, UShortVariable.switchToUnsigned(value));
        this.myMinValue = UnsignedNumberDocument.BIGINT_ZERO;
        this.myMaxValue = UnsignedNumberDocument.MAX_USHORT;
    }

    public UShortVariable(String label, BigInteger value, BigInteger min, BigInteger max) {
        super(label);
        this.myValue = UShortVariable.switchToUnsigned(String.valueOf(value));
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public UShortVariable(String label, String value, BigInteger min, BigInteger max) {
        super(label, UShortVariable.switchToUnsigned(value));
        this.myMinValue = min;
        this.myMaxValue = max;
    }

    public UShortVariable(UShortVariable v) {
        super(v);
        this.myValue = UShortVariable.switchToUnsigned(v.myValue);
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
    }

    @Override
    public Object clone() {
        return new UShortVariable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(UShortVariable.switchToUnsigned(value))) {
            BigInteger bigInt = new BigInteger(value);
            return new Short(bigInt.shortValue());
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "UShort";
    }

    @Override
    public Class<?> getValueClass() {
        return Short.class;
    }

    @Override
    public int getFormat() {
        return 14;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new UnsignedNumberDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = UShortVariable.switchToUnsigned(String.valueOf(v));
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = UShortVariable.switchToUnsigned(v);
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setEditorValue(String v) {
        if (this.myEditor != null) {
            boolean isValid;
            if (this.isValueValid(v)) {
                ((JTextComponent)this.myEditor).setDocument(this.myModel);
                isValid = true;
            } else {
                ((JTextComponent)this.myEditor).setDocument(new PlainDocument());
                isValid = false;
            }
            ((JTextComponent)this.myEditor).setBackground(isValid ? UIManager.getColor("TextField.background") : Color.RED);
            ((JTextComponent)this.myEditor).setText(v);
        } else {
            this.myValue = v;
        }
    }

    private static String switchToUnsigned(String value) {
        if (value.startsWith("-")) {
            return new BigInteger(Long.toBinaryString(Long.parseLong(value)).substring(48), 2).toString();
        }
        if (value.length() > 0) {
            return new BigInteger(value).toString();
        }
        return "";
    }

    public BigInteger getMinValue() {
        return this.myMinValue;
    }

    public BigInteger getMaxValue() {
        return this.myMaxValue;
    }

    @Override
    public String toString() {
        return this.myValue.toString();
    }
}

