/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.UnsignedInt16;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class UnsignedInt16Variable
extends AbstractNumberStringVariable {
    protected int myMinValue;
    protected int myMaxValue;

    public UnsignedInt16Variable(String label, UnsignedInt16 value) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(0, 65535);
    }

    public UnsignedInt16Variable(String label, String value) {
        super(label, value);
        this.setMinMax(0, 65535);
    }

    public UnsignedInt16Variable(String label, UnsignedInt16 value, int min, int max) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(min, max);
    }

    public UnsignedInt16Variable(String label, String value, int min, int max) {
        super(label, value);
        this.setMinMax(min, max);
    }

    public UnsignedInt16Variable(UnsignedInt16Variable v) {
        super(v);
        this.myValue = v.myValue;
        this.setMinMax(v.myMinValue, v.myMaxValue);
    }

    private void setMinMax(int min, int max) {
        this.myMinValue = min < 0 ? 0 : min;
        this.myMaxValue = max < 0 ? 0 : max;
    }

    @Override
    public Object clone() {
        return new UnsignedInt16Variable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return UnsignedInt16.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "UnsignedInt16";
    }

    public Class<UnsignedInt16> getValueClass() {
        return UnsignedInt16.class;
    }

    @Override
    public int getFormat() {
        return 2001;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

