/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.FilterableTypedDropDownVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.ValueTypeWrapper;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ValueFieldPanel
extends AbstractPanelVariableEditor
implements ActionListener,
DocumentListener {
    private boolean myHasFields;
    private JCheckBox myUseFieldCheckBox;
    private ValueFieldEditor myValueField;
    private TypedDropDownVariable<String> myFieldVariable;
    private FilterableTypedDropDownVariable myTooltipFieldVariable;
    private VariableListener myVariableListener = new VariableListener();
    private TypedDropDownVariable<ValueFieldEditor> myValueTypeVariable;
    private JPanel myValueEditorPanel;
    private Map<String, FieldDefinition> myFieldMap;
    private boolean myHasFieldEditor;
    private AvailableFieldListBuilder myBuilder;

    public ValueFieldPanel(ValueFieldCompositeObject value, Document doc, String[] availableFields) {
        this(value, doc, null, availableFields);
    }

    public ValueFieldPanel(ValueFieldCompositeObject value, Document document, DataType dataType, String[] availableFields) {
        this(value, new ValueFieldVariable.ValueType[]{new ValueFieldVariable.ValueType(document, dataType)}, null, availableFields);
    }

    public ValueFieldPanel(ValueFieldCompositeObject value, DataType type, String[] availableFields) {
        this(value, null, type, availableFields);
    }

    public ValueFieldPanel(ValueFieldCompositeObject valueObject, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selected, String[] availableFields) {
        this(valueObject, availableFields);
        ValueFieldVariable.ValueType initial = selected != null ? selected : valueTypes[0];
        this.setupValueFields(valueTypes, initial, valueObject);
        this.createPanel(valueObject);
    }

    public ValueFieldPanel(ValueFieldCompositeObject valueObject, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selected, Map<String, FieldDefinition> fieldMap) {
        this(valueObject, fieldMap);
        ValueFieldVariable.ValueType initial = selected != null ? selected : valueTypes[0];
        this.setupValueFields(valueTypes, initial, valueObject);
        this.createPanel(valueObject);
    }

    public ValueFieldPanel(ValueFieldCompositeObject valueObject, ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selected, AvailableFieldListBuilder builder) {
        this(valueObject, builder);
        ValueFieldVariable.ValueType initial = selected != null ? selected : valueTypes[0];
        this.setupValueFields(valueTypes, initial, valueObject);
        this.createPanel(valueObject);
    }

    private void setupValueFields(ValueFieldVariable.ValueType[] valueTypes, ValueFieldVariable.ValueType selected, ValueFieldCompositeObject valueObject) {
        ValueFieldEditor[] ret = new ValueFieldEditor[valueTypes.length];
        ValueFieldEditor current = null;
        for (int i = 0; i < valueTypes.length; ++i) {
            boolean isSelected = selected == valueTypes[i];
            ret[i] = this.createValueFieldEditor(valueTypes[i], isSelected, valueObject);
            if (!isSelected) continue;
            current = ret[i];
        }
        assert (current != null);
        this.myValueField = current;
        if (ret.length > 1) {
            this.myValueTypeVariable = new TypedDropDownVariable<Object>("", (T[])ret, current);
            this.myValueTypeVariable.setDataItem(new DataItemAdapter(){

                @Override
                public void setDataItem(Object reference, Object object) {
                    ValueFieldEditor editor = (ValueFieldEditor)ValueFieldPanel.this.myValueTypeVariable.getSelectedItem();
                    ValueFieldPanel.this.changeValueEditor(editor);
                }
            });
        }
    }

    protected void changeValueEditor(ValueFieldEditor editor) {
        Component current = this.myValueField.getEditor();
        Component ed = editor.getEditor();
        this.myValueEditorPanel.remove(current);
        this.myValueEditorPanel.add(ed, "Center");
        this.myValueField = editor;
        this.fireDataChanged();
    }

    @Override
    public synchronized void addContainerListener(ContainerListener l) {
        super.addContainerListener(l);
        this.myValueEditorPanel.addContainerListener(l);
    }

    @Override
    public synchronized void removeContainerListener(ContainerListener l) {
        this.myValueEditorPanel.removeContainerListener(l);
        super.removeContainerListener(l);
    }

    private ValueFieldEditor createValueFieldEditor(ValueFieldVariable.ValueType valueType, boolean selected, ValueFieldCompositeObject valueObject) {
        this.setupAndRegisterDocument(valueType.getDocument());
        String useValue = selected && valueObject.getMode().equals((Object)ValueFieldCompositeObject.Mode.Value) ? valueObject.getFieldOrValueAsString() : null;
        ValueFieldEditor editor = this.createEditorForValueType(valueType, useValue);
        editor.getVariable().setDataItem(this.myVariableListener);
        editor.getVariable().getEditor().setName("Component.ValueEditor");
        return editor;
    }

    private void setupAndRegisterDocument(Document doc) {
        if (doc != null) {
            try {
                if (doc.getLength() == 0) {
                    doc.insertString(0, "0", null);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            doc.addDocumentListener(this);
        }
    }

    private ValueFieldPanel(ValueFieldCompositeObject value, String[] availableFields) {
        this.setName("ValueFieldPanel");
        this.myHasFields = availableFields.length > 0;
        this.myFieldVariable = new TypedDropDownVariable<String>("", (T[])availableFields);
        this.myFieldVariable.setDataItem(this.myVariableListener);
        this.myTooltipFieldVariable = null;
        this.myFieldMap = null;
    }

    private ValueFieldPanel(ValueFieldCompositeObject value, Map<String, FieldDefinition> fieldMap) {
        this.setName("ValueFieldPanel");
        this.myHasFields = fieldMap.size() > 0;
        this.myTooltipFieldVariable = FilterableTypedDropDownVariable.builder("", new ArrayList<FieldDefinition>(fieldMap.values())).withItemDisplayer(new FieldOrientedPluginProfileUtil.FieldDisplayer()).build();
        this.myTooltipFieldVariable.setDataItem(this.myVariableListener);
        this.myFieldVariable = null;
        this.myFieldMap = fieldMap;
    }

    private ValueFieldPanel(ValueFieldCompositeObject value, AvailableFieldListBuilder builder) {
        this.setName("ValueFieldPanel");
        this.myHasFields = true;
        this.myTooltipFieldVariable = new LazyFieldDropDownVariable("", builder, value.getFieldOrValueAsString());
        this.myTooltipFieldVariable.setDataItem(this.myVariableListener);
        this.myFieldVariable = null;
        this.myBuilder = builder;
    }

    private void createPanel(ValueFieldCompositeObject value) {
        this.setLayout(new GridBagLayout());
        int row = 1;
        if (this.myValueTypeVariable != null) {
            Component editor = this.myValueTypeVariable.getEditor();
            editor.setName("JComboBox.ValueTypeSelector");
            this.add(editor, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        Component valueEditor = this.myValueField.getEditor();
        this.myValueEditorPanel = new JPanel(new BorderLayout());
        this.myValueEditorPanel.setName("ValuePanel");
        this.myValueEditorPanel.add(valueEditor, "Center");
        this.myUseFieldCheckBox = new JCheckBox("Use field");
        this.myUseFieldCheckBox.setName("JCheckBox.UseField");
        this.myUseFieldCheckBox.addActionListener(this);
        this.add((Component)this.myUseFieldCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.myValueEditorPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (value.getMode() == ValueFieldCompositeObject.Mode.Value) {
            valueEditor.setVisible(true);
            if (this.myBuilder == null) {
                JComboBox fieldSelector = this.useFieldDefinitions() ? (JComboBox)this.myTooltipFieldVariable.getEditor() : (JComboBox)this.myFieldVariable.getEditor();
                fieldSelector.setName("JComboBox.FieldSelector");
                this.add((Component)fieldSelector, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.myHasFieldEditor = true;
            }
        } else {
            this.myUseFieldCheckBox.setSelected(true);
            if (this.useFieldDefinitions()) {
                if (this.myBuilder != null) {
                    FieldHierarchyNode field = this.myBuilder.getClassRepository().getFieldRepository().getFieldByName(value.getFieldOrValueAsString());
                    if (field == null) {
                        this.myTooltipFieldVariable.setEditorText(value.getFieldOrValueAsString());
                    } else {
                        ((LazyFieldDropDownVariable)this.myTooltipFieldVariable).setSelectedItem(field);
                    }
                } else {
                    this.myTooltipFieldVariable.setSelectedItem(this.myFieldMap.get(value.getFieldOrValueAsString()));
                }
            } else {
                this.myFieldVariable.setSelectedItem(value.getFieldOrValueAsString());
            }
            valueEditor.setVisible(false);
            JComboBox fieldSelector = this.useFieldDefinitions() ? (JComboBox)this.myTooltipFieldVariable.getEditor() : (JComboBox)this.myFieldVariable.getEditor();
            fieldSelector.setName("JComboBox.FieldSelector");
            this.add((Component)fieldSelector, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.myHasFieldEditor = true;
        }
        this.updateVisibleEditor(value.getMode() == ValueFieldCompositeObject.Mode.Field);
    }

    @Override
    public Object getEditorValue() {
        String value;
        boolean isField = this.myUseFieldCheckBox.isSelected();
        ValueFieldVariable.ValueType valueType = this.myValueField.getValueType();
        if (isField) {
            if (!this.myHasFieldEditor) {
                Component fieldSelector = this.useFieldDefinitions() ? this.myTooltipFieldVariable.getEditor() : this.myFieldVariable.getEditor();
                fieldSelector.setName("JComboBox.FieldSelector");
                this.add(fieldSelector, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.myHasFieldEditor = true;
            }
            value = this.useFieldDefinitions() ? (this.myTooltipFieldVariable.getClass() == LazyFieldDropDownVariable.class ? ((FieldHierarchyNode)((LazyFieldDropDownVariable)this.myTooltipFieldVariable).getSelectedItem()).getFieldName() : ((FieldDefinition)this.myTooltipFieldVariable.getSelectedItem()).getFieldName()) : this.myFieldVariable.getSelectedItem();
        } else {
            value = this.myValueField.getValueAsString();
            if (value == null) {
                value = "";
            }
        }
        ValueFieldCompositeObject vfco = isField ? ValueFieldCompositeObject.createForField(value) : (valueType.hasValueClassFactory() ? ValueFieldCompositeObject.createForValue(value, null) : ValueFieldCompositeObject.createForValue(value, valueType.getDataType()));
        return vfco;
    }

    @Override
    public boolean isEditorValueValid() {
        if (!this.myUseFieldCheckBox.isSelected()) {
            return this.myValueField.getVariable().isValueValid();
        }
        return this.useFieldDefinitions() ? this.myTooltipFieldVariable.isValueValid() : this.myFieldVariable.isValueValid();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateVisibleEditor(((JCheckBox)e.getSource()).isSelected());
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    public void setEditorValue(ValueFieldCompositeObject value) {
        VariablePanelListener temp = this.myVariablePanelListener;
        this.myVariablePanelListener = null;
        boolean isField = value.getMode() == ValueFieldCompositeObject.Mode.Field;
        this.myUseFieldCheckBox.setSelected(isField);
        if (isField) {
            if (this.useFieldDefinitions()) {
                this.myTooltipFieldVariable.setSelectedItem(this.myFieldMap.get(value.getFieldOrValueAsString()));
            } else {
                this.myFieldVariable.setSelectedItem(value.getFieldOrValueAsString());
            }
        } else {
            this.myValueField.setValue(value.getFieldOrValueAsString());
        }
        this.updateVisibleEditor(isField);
        this.myVariablePanelListener = temp;
    }

    private void updateVisibleEditor(boolean isField) {
        if (isField || this.myHasFieldEditor) {
            Component editor;
            Component component = editor = this.useFieldDefinitions() ? this.myTooltipFieldVariable.getEditor() : this.myFieldVariable.getEditor();
            if (!this.myHasFieldEditor) {
                editor.setName("JComboBox.FieldSelector");
                this.add(editor, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.myHasFieldEditor = true;
            }
            editor.setVisible(isField);
        }
        this.myValueField.getEditor().setVisible(!isField);
        if (this.myValueTypeVariable != null) {
            this.myValueTypeVariable.getEditor().setVisible(!isField);
        }
        this.updateCheckBoxEnabledState();
        this.revalidate();
        this.repaint();
    }

    public boolean inUseFieldMode() {
        return this.myUseFieldCheckBox.isSelected();
    }

    private void updateCheckBoxEnabledState() {
        this.myUseFieldCheckBox.setEnabled(this.myHasFields || this.inUseFieldMode());
    }

    private boolean useFieldDefinitions() {
        return this.myTooltipFieldVariable != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myValueField.getVariable().setEnabled(enabled);
        if (enabled) {
            this.updateCheckBoxEnabledState();
        } else {
            this.myUseFieldCheckBox.setEnabled(false);
        }
        super.setEnabled(enabled);
    }

    protected ValueFieldEditor createEditorForValueType(ValueFieldVariable.ValueType valueType, String value) {
        Variable var = valueType.createVariable("", value);
        if (var == null) {
            ValueTypeWrapper wrapper = new ValueTypeWrapper(valueType);
            var = ((ValueFieldVariable.ValueType)wrapper).createVariable("", value);
        }
        return new ValueFieldEditor(var, valueType);
    }

    private class VariableListener
    extends DataItemAdapter {
        private VariableListener() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            ValueFieldPanel.this.fireDataChanged();
        }
    }

    public static class ValueFieldEditor {
        private Variable myVariable;
        private ValueFieldVariable.ValueType myValueType;

        public ValueFieldEditor(Variable var, ValueFieldVariable.ValueType valueType) {
            this.myVariable = var;
            this.myValueType = valueType;
        }

        protected void setValue(String value) {
            this.myVariable.setValue(value);
        }

        protected String getValueAsString() {
            return this.myVariable.getValueString();
        }

        public Component getEditor() {
            return this.myVariable.getEditor();
        }

        protected Variable getVariable() {
            return this.myVariable;
        }

        ValueFieldVariable.ValueType getValueType() {
            return this.myValueType;
        }

        public String toString() {
            return this.myValueType.getDescription() != null ? this.myValueType.getDescription() : super.toString();
        }
    }
}

