/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.DataType;
import ericsson.ere.exception.NotImplementedException;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.util.Calendar;
import javax.swing.text.Document;

public class ValueTypeWrapper
extends ValueFieldVariable.ValueType {
    private EditorForDataType myEditorType;

    public ValueTypeWrapper(ValueFieldVariable.ValueType valueType) {
        super(valueType.getDocument(), valueType.getDataType(), valueType.getDescription());
        this.myEditorType = this.findEditorType(valueType);
    }

    private EditorForDataType findEditorType(ValueFieldVariable.ValueType valueType) {
        EditorForDataType edtype;
        DataType dt = valueType.getDataType();
        if (dt == null) {
            dt = DataType.STRING;
        }
        switch (dt) {
            case DATE: {
                edtype = EditorForDataType.DATE_EDITOR;
                break;
            }
            case TIME: {
                edtype = EditorForDataType.TIME_EDITOR;
                break;
            }
            case STRING: {
                edtype = EditorForDataType.STRING_EDITOR;
                break;
            }
            case AMOUNT: {
                edtype = EditorForDataType.AMOUNT_EDITOR;
                break;
            }
            case RATINGDECIMAL: {
                edtype = EditorForDataType.RATINGDECIMAL_EDITOR;
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        return edtype;
    }

    @Override
    public Variable createVariable(String label, String value) {
        return this.myEditorType.createTypeVariable(label, this, value);
    }

    static enum EditorForDataType {
        DATE_EDITOR{

            @Override
            public Variable createTypeVariable(String label, ValueFieldVariable.ValueType valueType, String value) {
                if (value != null) {
                    return new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE, value);
                }
                return new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE, Calendar.getInstance());
            }
        }
        ,
        TIME_EDITOR{

            @Override
            public Variable createTypeVariable(String label, ValueFieldVariable.ValueType valueType, String value) {
                if (value != null) {
                    return new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, value);
                }
                return new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, Calendar.getInstance());
            }
        }
        ,
        STRING_EDITOR{

            @Override
            public Variable createTypeVariable(String label, ValueFieldVariable.ValueType valueType, String value) {
                Document document = valueType.getDocument();
                if (document != null) {
                    DataType dataType = valueType.getDataType();
                    boolean isNumeric = dataType == null || dataType.isNumeric();
                    String nullValue = isNumeric ? "0" : "";
                    String useValue = value != null ? value : nullValue;
                    return new StringVariable(label, useValue, document);
                }
                return new StringVariable(label, value);
            }
        }
        ,
        AMOUNT_EDITOR{

            @Override
            public Variable createTypeVariable(String label, ValueFieldVariable.ValueType valueType, String value) {
                assert (!(valueType instanceof ValueFieldVariable.AmountValueType)) : "AmountValueType implements createVariable, so we shouldn't get here!";
                return VariableFactory.getVariableOfDataType("Amount", label, null, null, null, value);
            }
        }
        ,
        RATINGDECIMAL_EDITOR{

            @Override
            public Variable createTypeVariable(String label, ValueFieldVariable.ValueType valueType, String value) {
                String varValue = value != null ? value : "0";
                RatingDecimalVariable var = new RatingDecimalVariable(label, varValue);
                Document doc = valueType.getDocument();
                if (doc != null) {
                    var.setModel(doc);
                }
                return var;
            }
        };


        abstract Variable createTypeVariable(String var1, ValueFieldVariable.ValueType var2, String var3);
    }
}

